@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin.inputs

import com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupRulesSourceStatefulRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property action Action to take with packets in a traffic flow when the flow matches the stateful rule criteria. For all actions, AWS Network Firewall performs the specified action and discontinues stateful inspection of the traffic flow. Valid values: `ALERT`, `DROP`, `PASS`, or `REJECT`.
 * @property header A configuration block containing the stateful 5-tuple inspection criteria for the rule, used to inspect traffic flows. See Header below for details.
 * @property ruleOptions Set of configuration blocks containing additional settings for a stateful rule. See Rule Option below for details.
 */
public data class RuleGroupRuleGroupRulesSourceStatefulRuleArgs(
    public val action: Output<String>,
    public val `header`: Output<RuleGroupRuleGroupRulesSourceStatefulRuleHeaderArgs>,
    public val ruleOptions: Output<List<RuleGroupRuleGroupRulesSourceStatefulRuleRuleOptionArgs>>,
) :
    ConvertibleToJava<com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupRulesSourceStatefulRuleArgs> {
    override fun toJava():
        com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupRulesSourceStatefulRuleArgs =
        com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupRulesSourceStatefulRuleArgs.builder()
            .action(action.applyValue({ args0 -> args0 }))
            .`header`(`header`.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .ruleOptions(
                ruleOptions.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [RuleGroupRuleGroupRulesSourceStatefulRuleArgs].
 */
@PulumiTagMarker
public class RuleGroupRuleGroupRulesSourceStatefulRuleArgsBuilder internal constructor() {
    private var action: Output<String>? = null

    private var `header`: Output<RuleGroupRuleGroupRulesSourceStatefulRuleHeaderArgs>? = null

    private var ruleOptions: Output<List<RuleGroupRuleGroupRulesSourceStatefulRuleRuleOptionArgs>>? =
        null

    /**
     * @param value Action to take with packets in a traffic flow when the flow matches the stateful rule criteria. For all actions, AWS Network Firewall performs the specified action and discontinues stateful inspection of the traffic flow. Valid values: `ALERT`, `DROP`, `PASS`, or `REJECT`.
     */
    @JvmName("ajmawbqaymaaagii")
    public suspend fun action(`value`: Output<String>) {
        this.action = value
    }

    /**
     * @param value A configuration block containing the stateful 5-tuple inspection criteria for the rule, used to inspect traffic flows. See Header below for details.
     */
    @JvmName("xxsrbyrxfiwscwgk")
    public suspend
    fun `header`(`value`: Output<RuleGroupRuleGroupRulesSourceStatefulRuleHeaderArgs>) {
        this.`header` = value
    }

    /**
     * @param value Set of configuration blocks containing additional settings for a stateful rule. See Rule Option below for details.
     */
    @JvmName("desajiqkgosxaagg")
    public suspend
    fun ruleOptions(`value`: Output<List<RuleGroupRuleGroupRulesSourceStatefulRuleRuleOptionArgs>>) {
        this.ruleOptions = value
    }

    @JvmName("hjyauvccecwuhhgs")
    public suspend fun ruleOptions(
        vararg
        values: Output<RuleGroupRuleGroupRulesSourceStatefulRuleRuleOptionArgs>,
    ) {
        this.ruleOptions = Output.all(values.asList())
    }

    /**
     * @param values Set of configuration blocks containing additional settings for a stateful rule. See Rule Option below for details.
     */
    @JvmName("vsnisuammkvnbhdc")
    public suspend
    fun ruleOptions(values: List<Output<RuleGroupRuleGroupRulesSourceStatefulRuleRuleOptionArgs>>) {
        this.ruleOptions = Output.all(values)
    }

    /**
     * @param value Action to take with packets in a traffic flow when the flow matches the stateful rule criteria. For all actions, AWS Network Firewall performs the specified action and discontinues stateful inspection of the traffic flow. Valid values: `ALERT`, `DROP`, `PASS`, or `REJECT`.
     */
    @JvmName("rlosybmlyciygvwg")
    public suspend fun action(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value A configuration block containing the stateful 5-tuple inspection criteria for the rule, used to inspect traffic flows. See Header below for details.
     */
    @JvmName("beutholodkxhtbtm")
    public suspend fun `header`(`value`: RuleGroupRuleGroupRulesSourceStatefulRuleHeaderArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`header` = mapped
    }

    /**
     * @param argument A configuration block containing the stateful 5-tuple inspection criteria for the rule, used to inspect traffic flows. See Header below for details.
     */
    @JvmName("cmrixjfnwylrhhbk")
    public suspend
    fun `header`(argument: suspend RuleGroupRuleGroupRulesSourceStatefulRuleHeaderArgsBuilder.() -> Unit) {
        val toBeMapped = RuleGroupRuleGroupRulesSourceStatefulRuleHeaderArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.`header` = mapped
    }

    /**
     * @param value Set of configuration blocks containing additional settings for a stateful rule. See Rule Option below for details.
     */
    @JvmName("wxhgrwbjgjlpming")
    public suspend
    fun ruleOptions(`value`: List<RuleGroupRuleGroupRulesSourceStatefulRuleRuleOptionArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleOptions = mapped
    }

    /**
     * @param argument Set of configuration blocks containing additional settings for a stateful rule. See Rule Option below for details.
     */
    @JvmName("lkjyrcjtqfkxpijd")
    public suspend
    fun ruleOptions(argument: List<suspend RuleGroupRuleGroupRulesSourceStatefulRuleRuleOptionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleGroupRulesSourceStatefulRuleRuleOptionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ruleOptions = mapped
    }

    /**
     * @param argument Set of configuration blocks containing additional settings for a stateful rule. See Rule Option below for details.
     */
    @JvmName("ombshiwjrhgjruim")
    public suspend fun ruleOptions(
        vararg
        argument: suspend RuleGroupRuleGroupRulesSourceStatefulRuleRuleOptionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleGroupRulesSourceStatefulRuleRuleOptionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ruleOptions = mapped
    }

    /**
     * @param argument Set of configuration blocks containing additional settings for a stateful rule. See Rule Option below for details.
     */
    @JvmName("awajmmligakvgrhx")
    public suspend
    fun ruleOptions(argument: suspend RuleGroupRuleGroupRulesSourceStatefulRuleRuleOptionArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                RuleGroupRuleGroupRulesSourceStatefulRuleRuleOptionArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.ruleOptions = mapped
    }

    /**
     * @param values Set of configuration blocks containing additional settings for a stateful rule. See Rule Option below for details.
     */
    @JvmName("niymaeptvwyrpgjl")
    public suspend fun ruleOptions(
        vararg
        values: RuleGroupRuleGroupRulesSourceStatefulRuleRuleOptionArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleOptions = mapped
    }

    internal fun build(): RuleGroupRuleGroupRulesSourceStatefulRuleArgs =
        RuleGroupRuleGroupRulesSourceStatefulRuleArgs(
            action = action ?: throw PulumiNullFieldException("action"),
            `header` = `header` ?: throw PulumiNullFieldException("header"),
            ruleOptions = ruleOptions ?: throw PulumiNullFieldException("ruleOptions"),
        )
}
