@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin.inputs

import com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property customActions Set of configuration blocks containing custom action definitions that are available for use by the set of `stateless rule`. See Custom Action below for details.
 * @property statelessRules Set of configuration blocks containing the stateless rules for use in the stateless rule group. See Stateless Rule below for details.
 */
public data class RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsArgs(
    public val customActions:
    Output<List<RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsCustomActionArgs>>? =
        null,
    public val statelessRules:
    Output<List<RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsStatelessRuleArgs>>,
) :
    ConvertibleToJava<com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsArgs> {
    override fun toJava():
        com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsArgs =
        com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsArgs.builder()
            .customActions(
                customActions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .statelessRules(
                statelessRules.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsArgs].
 */
@PulumiTagMarker
public class RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsArgsBuilder internal
constructor() {
    private var customActions:
        Output<List<RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsCustomActionArgs>>? =
        null

    private var statelessRules:
        Output<List<RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsStatelessRuleArgs>>? =
        null

    /**
     * @param value Set of configuration blocks containing custom action definitions that are available for use by the set of `stateless rule`. See Custom Action below for details.
     */
    @JvmName("piixwjumotyimidn")
    public suspend
    fun customActions(`value`: Output<List<RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsCustomActionArgs>>) {
        this.customActions = value
    }

    @JvmName("quvbmnkuledyvhhu")
    public suspend fun customActions(
        vararg
        values: Output<RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsCustomActionArgs>,
    ) {
        this.customActions = Output.all(values.asList())
    }

    /**
     * @param values Set of configuration blocks containing custom action definitions that are available for use by the set of `stateless rule`. See Custom Action below for details.
     */
    @JvmName("gbkmnejkdekmjmnm")
    public suspend
    fun customActions(values: List<Output<RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsCustomActionArgs>>) {
        this.customActions = Output.all(values)
    }

    /**
     * @param value Set of configuration blocks containing the stateless rules for use in the stateless rule group. See Stateless Rule below for details.
     */
    @JvmName("tfbondiwfuvbiqpx")
    public suspend
    fun statelessRules(`value`: Output<List<RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsStatelessRuleArgs>>) {
        this.statelessRules = value
    }

    @JvmName("bkhlthwnwngopdsi")
    public suspend fun statelessRules(
        vararg
        values: Output<RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsStatelessRuleArgs>,
    ) {
        this.statelessRules = Output.all(values.asList())
    }

    /**
     * @param values Set of configuration blocks containing the stateless rules for use in the stateless rule group. See Stateless Rule below for details.
     */
    @JvmName("sjpdeekihsvuhvfh")
    public suspend
    fun statelessRules(values: List<Output<RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsStatelessRuleArgs>>) {
        this.statelessRules = Output.all(values)
    }

    /**
     * @param value Set of configuration blocks containing custom action definitions that are available for use by the set of `stateless rule`. See Custom Action below for details.
     */
    @JvmName("qprxhetwiijidsfk")
    public suspend
    fun customActions(`value`: List<RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsCustomActionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customActions = mapped
    }

    /**
     * @param argument Set of configuration blocks containing custom action definitions that are available for use by the set of `stateless rule`. See Custom Action below for details.
     */
    @JvmName("arfxggrxurofjaxq")
    public suspend
    fun customActions(argument: List<suspend RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsCustomActionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsCustomActionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.customActions = mapped
    }

    /**
     * @param argument Set of configuration blocks containing custom action definitions that are available for use by the set of `stateless rule`. See Custom Action below for details.
     */
    @JvmName("mldqhjkowcmkomuu")
    public suspend fun customActions(
        vararg
        argument: suspend RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsCustomActionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsCustomActionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.customActions = mapped
    }

    /**
     * @param argument Set of configuration blocks containing custom action definitions that are available for use by the set of `stateless rule`. See Custom Action below for details.
     */
    @JvmName("eapekdkqifpbvuwi")
    public suspend
    fun customActions(argument: suspend RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsCustomActionArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsCustomActionArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.customActions = mapped
    }

    /**
     * @param values Set of configuration blocks containing custom action definitions that are available for use by the set of `stateless rule`. See Custom Action below for details.
     */
    @JvmName("xjwtxjlbjkadrvmq")
    public suspend fun customActions(
        vararg
        values: RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsCustomActionArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customActions = mapped
    }

    /**
     * @param value Set of configuration blocks containing the stateless rules for use in the stateless rule group. See Stateless Rule below for details.
     */
    @JvmName("gkugcipencaablul")
    public suspend
    fun statelessRules(`value`: List<RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsStatelessRuleArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.statelessRules = mapped
    }

    /**
     * @param argument Set of configuration blocks containing the stateless rules for use in the stateless rule group. See Stateless Rule below for details.
     */
    @JvmName("cnmstsdddannxqfd")
    public suspend
    fun statelessRules(argument: List<suspend RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsStatelessRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsStatelessRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.statelessRules = mapped
    }

    /**
     * @param argument Set of configuration blocks containing the stateless rules for use in the stateless rule group. See Stateless Rule below for details.
     */
    @JvmName("wyiplybeuyoherdk")
    public suspend fun statelessRules(
        vararg
        argument: suspend RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsStatelessRuleArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsStatelessRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.statelessRules = mapped
    }

    /**
     * @param argument Set of configuration blocks containing the stateless rules for use in the stateless rule group. See Stateless Rule below for details.
     */
    @JvmName("vuccxwxurhwmppck")
    public suspend
    fun statelessRules(argument: suspend RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsStatelessRuleArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsStatelessRuleArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.statelessRules = mapped
    }

    /**
     * @param values Set of configuration blocks containing the stateless rules for use in the stateless rule group. See Stateless Rule below for details.
     */
    @JvmName("qegferwkunewttwv")
    public suspend fun statelessRules(
        vararg
        values: RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsStatelessRuleArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.statelessRules = mapped
    }

    internal fun build(): RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsArgs =
        RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsArgs(
            customActions = customActions,
            statelessRules = statelessRules ?: throw PulumiNullFieldException("statelessRules"),
        )
}
