@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin.inputs

import com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsCustomActionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property actionDefinition A configuration block describing the custom action associated with the `action_name`. See Action Definition below for details.
 * @property actionName A friendly name of the custom action.
 */
public data class RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsCustomActionArgs(
    public val actionDefinition:
    Output<RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsCustomActionActionDefinitionArgs>,
    public val actionName: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsCustomActionArgs> {
    override fun toJava():
        com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsCustomActionArgs =
        com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsCustomActionArgs.builder()
            .actionDefinition(actionDefinition.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .actionName(actionName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsCustomActionArgs].
 */
@PulumiTagMarker
public class RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsCustomActionArgsBuilder
internal constructor() {
    private var actionDefinition:
        Output<RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsCustomActionActionDefinitionArgs>? =
        null

    private var actionName: Output<String>? = null

    /**
     * @param value A configuration block describing the custom action associated with the `action_name`. See Action Definition below for details.
     */
    @JvmName("txduyukwacblmnqb")
    public suspend
    fun actionDefinition(`value`: Output<RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsCustomActionActionDefinitionArgs>) {
        this.actionDefinition = value
    }

    /**
     * @param value A friendly name of the custom action.
     */
    @JvmName("euxsfsptduaywxuc")
    public suspend fun actionName(`value`: Output<String>) {
        this.actionName = value
    }

    /**
     * @param value A configuration block describing the custom action associated with the `action_name`. See Action Definition below for details.
     */
    @JvmName("ytduvriverbptdud")
    public suspend
    fun actionDefinition(`value`: RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsCustomActionActionDefinitionArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actionDefinition = mapped
    }

    /**
     * @param argument A configuration block describing the custom action associated with the `action_name`. See Action Definition below for details.
     */
    @JvmName("mqjvhquhvitnvkqt")
    public suspend
    fun actionDefinition(argument: suspend RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsCustomActionActionDefinitionArgsBuilder.() -> Unit) {
        val toBeMapped =
            RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsCustomActionActionDefinitionArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.actionDefinition = mapped
    }

    /**
     * @param value A friendly name of the custom action.
     */
    @JvmName("waogqotwtmefwfym")
    public suspend fun actionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actionName = mapped
    }

    internal fun build(): RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsCustomActionArgs =
        RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsCustomActionArgs(
            actionDefinition = actionDefinition ?: throw PulumiNullFieldException("actionDefinition"),
            actionName = actionName ?: throw PulumiNullFieldException("actionName"),
        )
}
