@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin.inputs

import com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupStatefulRuleOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property ruleOrder Indicates how to manage the order of the rule evaluation for the rule group. Default value: `DEFAULT_ACTION_ORDER`. Valid values: `DEFAULT_ACTION_ORDER`, `STRICT_ORDER`.
 */
public data class RuleGroupRuleGroupStatefulRuleOptionsArgs(
    public val ruleOrder: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupStatefulRuleOptionsArgs> {
    override fun toJava():
        com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupStatefulRuleOptionsArgs =
        com.pulumi.aws.networkfirewall.inputs.RuleGroupRuleGroupStatefulRuleOptionsArgs.builder()
            .ruleOrder(ruleOrder.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RuleGroupRuleGroupStatefulRuleOptionsArgs].
 */
@PulumiTagMarker
public class RuleGroupRuleGroupStatefulRuleOptionsArgsBuilder internal constructor() {
    private var ruleOrder: Output<String>? = null

    /**
     * @param value Indicates how to manage the order of the rule evaluation for the rule group. Default value: `DEFAULT_ACTION_ORDER`. Valid values: `DEFAULT_ACTION_ORDER`, `STRICT_ORDER`.
     */
    @JvmName("gksjubqcxomvncaa")
    public suspend fun ruleOrder(`value`: Output<String>) {
        this.ruleOrder = value
    }

    /**
     * @param value Indicates how to manage the order of the rule evaluation for the rule group. Default value: `DEFAULT_ACTION_ORDER`. Valid values: `DEFAULT_ACTION_ORDER`, `STRICT_ORDER`.
     */
    @JvmName("glfegkivetrumhhs")
    public suspend fun ruleOrder(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleOrder = mapped
    }

    internal fun build(): RuleGroupRuleGroupStatefulRuleOptionsArgs =
        RuleGroupRuleGroupStatefulRuleOptionsArgs(
            ruleOrder = ruleOrder ?: throw PulumiNullFieldException("ruleOrder"),
        )
}
