@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property attachments Nested list describing the attachment status of the firewall's association with a single VPC subnet.
 * @property availabilityZone The Availability Zone where the subnet is configured.
 */
public data class FirewallFirewallStatusSyncState(
    public val attachments: List<FirewallFirewallStatusSyncStateAttachment>? = null,
    public val availabilityZone: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.networkfirewall.outputs.FirewallFirewallStatusSyncState):
            FirewallFirewallStatusSyncState = FirewallFirewallStatusSyncState(
            attachments = javaType.attachments().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.networkfirewall.kotlin.outputs.FirewallFirewallStatusSyncStateAttachment.Companion.toKotlin(args0)
                })
            }),
            availabilityZone = javaType.availabilityZone().map({ args0 -> args0 }).orElse(null),
        )
    }
}
