@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property endpointId The identifier of the firewall endpoint that AWS Network Firewall has instantiated in the subnet. You use this to identify the firewall endpoint in the VPC route tables, when you redirect the VPC traffic through the endpoint.
 * @property subnetId The unique identifier for the subnet.
 */
public data class FirewallFirewallStatusSyncStateAttachment(
    public val endpointId: String? = null,
    public val subnetId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.networkfirewall.outputs.FirewallFirewallStatusSyncStateAttachment):
            FirewallFirewallStatusSyncStateAttachment = FirewallFirewallStatusSyncStateAttachment(
            endpointId = javaType.endpointId().map({ args0 -> args0 }).orElse(null),
            subnetId = javaType.subnetId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
