@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property policyVariables . Contains variables that you can use to override default Suricata settings in your firewall policy. See Rule Variables for details.
 * @property statefulDefaultActions Set of actions to take on a packet if it does not match any stateful rules in the policy. This can only be specified if the policy has a `stateful_engine_options` block with a `rule_order` value of `STRICT_ORDER`. You can specify one of either or neither values of `aws:drop_strict` or `aws:drop_established`, as well as any combination of `aws:alert_strict` and `aws:alert_established`.
 * @property statefulEngineOptions A configuration block that defines options on how the policy handles stateful rules. See Stateful Engine Options below for details.
 * @property statefulRuleGroupReferences Set of configuration blocks containing references to the stateful rule groups that are used in the policy. See Stateful Rule Group Reference below for details.
 * @property statelessCustomActions Set of configuration blocks describing the custom action definitions that are available for use in the firewall policy's `stateless_default_actions`. See Stateless Custom Action below for details.
 * @property statelessDefaultActions Set of actions to take on a packet if it does not match any of the stateless rules in the policy. You must specify one of the standard actions including: `aws:drop`, `aws:pass`, or `aws:forward_to_sfe`.
 * In addition, you can specify custom actions that are compatible with your standard action choice. If you want non-matching packets to be forwarded for stateful inspection, specify `aws:forward_to_sfe`.
 * @property statelessFragmentDefaultActions Set of actions to take on a fragmented packet if it does not match any of the stateless rules in the policy. You must specify one of the standard actions including: `aws:drop`, `aws:pass`, or `aws:forward_to_sfe`.
 * In addition, you can specify custom actions that are compatible with your standard action choice. If you want non-matching packets to be forwarded for stateful inspection, specify `aws:forward_to_sfe`.
 * @property statelessRuleGroupReferences Set of configuration blocks containing references to the stateless rule groups that are used in the policy. See Stateless Rule Group Reference below for details.
 */
public data class FirewallPolicyFirewallPolicy(
    public val policyVariables: FirewallPolicyFirewallPolicyPolicyVariables? = null,
    public val statefulDefaultActions: List<String>? = null,
    public val statefulEngineOptions: FirewallPolicyFirewallPolicyStatefulEngineOptions? = null,
    public val statefulRuleGroupReferences:
    List<FirewallPolicyFirewallPolicyStatefulRuleGroupReference>? = null,
    public val statelessCustomActions: List<FirewallPolicyFirewallPolicyStatelessCustomAction>? =
        null,
    public val statelessDefaultActions: List<String>,
    public val statelessFragmentDefaultActions: List<String>,
    public val statelessRuleGroupReferences:
    List<FirewallPolicyFirewallPolicyStatelessRuleGroupReference>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.networkfirewall.outputs.FirewallPolicyFirewallPolicy):
            FirewallPolicyFirewallPolicy = FirewallPolicyFirewallPolicy(
            policyVariables = javaType.policyVariables().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.networkfirewall.kotlin.outputs.FirewallPolicyFirewallPolicyPolicyVariables.Companion.toKotlin(args0)
                })
            }).orElse(null),
            statefulDefaultActions = javaType.statefulDefaultActions().map({ args0 -> args0 }),
            statefulEngineOptions = javaType.statefulEngineOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.networkfirewall.kotlin.outputs.FirewallPolicyFirewallPolicyStatefulEngineOptions.Companion.toKotlin(args0)
                })
            }).orElse(null),
            statefulRuleGroupReferences = javaType.statefulRuleGroupReferences().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.networkfirewall.kotlin.outputs.FirewallPolicyFirewallPolicyStatefulRuleGroupReference.Companion.toKotlin(args0)
                })
            }),
            statelessCustomActions = javaType.statelessCustomActions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.networkfirewall.kotlin.outputs.FirewallPolicyFirewallPolicyStatelessCustomAction.Companion.toKotlin(args0)
                })
            }),
            statelessDefaultActions = javaType.statelessDefaultActions().map({ args0 -> args0 }),
            statelessFragmentDefaultActions = javaType.statelessFragmentDefaultActions().map({ args0 ->
                args0
            }),
            statelessRuleGroupReferences = javaType.statelessRuleGroupReferences().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.networkfirewall.kotlin.outputs.FirewallPolicyFirewallPolicyStatelessRuleGroupReference.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
