@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property override Configuration block for override values
 * @property priority An integer setting that indicates the order in which to apply the stateful rule groups in a single policy. This argument must be specified if the policy has a `stateful_engine_options` block with a `rule_order` value of `STRICT_ORDER`. AWS Network Firewall applies each stateful rule group to a packet starting with the group that has the lowest priority setting.
 * @property resourceArn The Amazon Resource Name (ARN) of the stateful rule group.
 */
public data class FirewallPolicyFirewallPolicyStatefulRuleGroupReference(
    public val `override`: FirewallPolicyFirewallPolicyStatefulRuleGroupReferenceOverride? = null,
    public val priority: Int? = null,
    public val resourceArn: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.networkfirewall.outputs.FirewallPolicyFirewallPolicyStatefulRuleGroupReference):
            FirewallPolicyFirewallPolicyStatefulRuleGroupReference =
            FirewallPolicyFirewallPolicyStatefulRuleGroupReference(
                `override` = javaType.`override`().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.networkfirewall.kotlin.outputs.FirewallPolicyFirewallPolicyStatefulRuleGroupReferenceOverride.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                priority = javaType.priority().map({ args0 -> args0 }).orElse(null),
                resourceArn = javaType.resourceArn(),
            )
    }
}
