@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property actionDefinition A configuration block describing the custom action associated with the `action_name`. See Action Definition below for details.
 * @property actionName A friendly name of the custom action.
 */
public data class FirewallPolicyFirewallPolicyStatelessCustomAction(
    public val actionDefinition: FirewallPolicyFirewallPolicyStatelessCustomActionActionDefinition,
    public val actionName: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.networkfirewall.outputs.FirewallPolicyFirewallPolicyStatelessCustomAction):
            FirewallPolicyFirewallPolicyStatelessCustomAction =
            FirewallPolicyFirewallPolicyStatelessCustomAction(
                actionDefinition = javaType.actionDefinition().let({ args0 ->
                    com.pulumi.aws.networkfirewall.kotlin.outputs.FirewallPolicyFirewallPolicyStatelessCustomActionActionDefinition.Companion.toKotlin(args0)
                }),
                actionName = javaType.actionName(),
            )
    }
}
