@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property priority An integer setting that indicates the order in which to run the stateless rule groups in a single policy. AWS Network Firewall applies each stateless rule group to a packet starting with the group that has the lowest priority setting.
 * @property resourceArn The Amazon Resource Name (ARN) of the stateless rule group.
 */
public data class FirewallPolicyFirewallPolicyStatelessRuleGroupReference(
    public val priority: Int,
    public val resourceArn: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.networkfirewall.outputs.FirewallPolicyFirewallPolicyStatelessRuleGroupReference):
            FirewallPolicyFirewallPolicyStatelessRuleGroupReference =
            FirewallPolicyFirewallPolicyStatelessRuleGroupReference(
                priority = javaType.priority(),
                resourceArn = javaType.resourceArn(),
            )
    }
}
