@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property keyId The ID of the AWS Key Management Service (AWS KMS) customer managed key.
 * @property type The type of the AWS Key Management Service (AWS KMS) key use by the firewall.
 */
public data class GetFirewallEncryptionConfiguration(
    public val keyId: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.networkfirewall.outputs.GetFirewallEncryptionConfiguration):
            GetFirewallEncryptionConfiguration = GetFirewallEncryptionConfiguration(
            keyId = javaType.keyId(),
            type = javaType.type(),
        )
    }
}
