@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property statefulDefaultActions
 * @property statefulEngineOptions
 * @property statefulRuleGroupReferences
 * @property statelessCustomActions
 * @property statelessDefaultActions
 * @property statelessFragmentDefaultActions
 * @property statelessRuleGroupReferences
 */
public data class GetFirewallPolicyFirewallPolicy(
    public val statefulDefaultActions: List<String>,
    public val statefulEngineOptions: List<GetFirewallPolicyFirewallPolicyStatefulEngineOption>,
    public val statefulRuleGroupReferences:
    List<GetFirewallPolicyFirewallPolicyStatefulRuleGroupReference>,
    public val statelessCustomActions: List<GetFirewallPolicyFirewallPolicyStatelessCustomAction>,
    public val statelessDefaultActions: List<String>,
    public val statelessFragmentDefaultActions: List<String>,
    public val statelessRuleGroupReferences:
    List<GetFirewallPolicyFirewallPolicyStatelessRuleGroupReference>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.networkfirewall.outputs.GetFirewallPolicyFirewallPolicy):
            GetFirewallPolicyFirewallPolicy = GetFirewallPolicyFirewallPolicy(
            statefulDefaultActions = javaType.statefulDefaultActions().map({ args0 -> args0 }),
            statefulEngineOptions = javaType.statefulEngineOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.networkfirewall.kotlin.outputs.GetFirewallPolicyFirewallPolicyStatefulEngineOption.Companion.toKotlin(args0)
                })
            }),
            statefulRuleGroupReferences = javaType.statefulRuleGroupReferences().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.networkfirewall.kotlin.outputs.GetFirewallPolicyFirewallPolicyStatefulRuleGroupReference.Companion.toKotlin(args0)
                })
            }),
            statelessCustomActions = javaType.statelessCustomActions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.networkfirewall.kotlin.outputs.GetFirewallPolicyFirewallPolicyStatelessCustomAction.Companion.toKotlin(args0)
                })
            }),
            statelessDefaultActions = javaType.statelessDefaultActions().map({ args0 -> args0 }),
            statelessFragmentDefaultActions = javaType.statelessFragmentDefaultActions().map({ args0 ->
                args0
            }),
            statelessRuleGroupReferences = javaType.statelessRuleGroupReferences().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.networkfirewall.kotlin.outputs.GetFirewallPolicyFirewallPolicyStatelessRuleGroupReference.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
