@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getResourcePolicy.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property policy The [policy][1] for the resource.
 * @property resourceArn
 */
public data class GetResourcePolicyResult(
    public val id: String,
    public val policy: String,
    public val resourceArn: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.networkfirewall.outputs.GetResourcePolicyResult):
            GetResourcePolicyResult = GetResourcePolicyResult(
            id = javaType.id(),
            policy = javaType.policy(),
            resourceArn = javaType.resourceArn(),
        )
    }
}
