@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property logDestination A map describing the logging destination for the chosen `log_destination_type`.
 * * For an Amazon S3 bucket, specify the key `bucketName` with the name of the bucket and optionally specify the key `prefix` with a path.
 * * For a CloudWatch log group, specify the key `logGroup` with the name of the CloudWatch log group.
 * * For a Kinesis Data Firehose delivery stream, specify the key `deliveryStream` with the name of the delivery stream.
 * @property logDestinationType The location to send logs to. Valid values: `S3`, `CloudWatchLogs`, `KinesisDataFirehose`.
 * @property logType The type of log to send. Valid values: `ALERT` or `FLOW`. Alert logs report traffic that matches a `StatefulRule` with an action setting that sends a log message. Flow logs are standard network traffic flow logs.
 */
public data class LoggingConfigurationLoggingConfigurationLogDestinationConfig(
    public val logDestination: Map<String, String>,
    public val logDestinationType: String,
    public val logType: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.networkfirewall.outputs.LoggingConfigurationLoggingConfigurationLogDestinationConfig):
            LoggingConfigurationLoggingConfigurationLogDestinationConfig =
            LoggingConfigurationLoggingConfigurationLogDestinationConfig(
                logDestination = javaType.logDestination().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                logDestinationType = javaType.logDestinationType(),
                logType = javaType.logType(),
            )
    }
}
