@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property referenceSets A configuration block that defines the IP Set References for the rule group. See Reference Sets below for details. Please notes that there can only be a maximum of 5 `reference_sets` in a `rule_group`. See the [AWS documentation](https://docs.aws.amazon.com/network-firewall/latest/developerguide/rule-groups-ip-set-references.html#rule-groups-ip-set-reference-limits) for details.
 * @property ruleVariables A configuration block that defines additional settings available to use in the rules defined in the rule group. Can only be specified for **stateful** rule groups. See Rule Variables below for details.
 * @property rulesSource A configuration block that defines the stateful or stateless rules for the rule group. See Rules Source below for details.
 * @property statefulRuleOptions A configuration block that defines stateful rule options for the rule group. See Stateful Rule Options below for details.
 */
public data class RuleGroupRuleGroup(
    public val referenceSets: RuleGroupRuleGroupReferenceSets? = null,
    public val ruleVariables: RuleGroupRuleGroupRuleVariables? = null,
    public val rulesSource: RuleGroupRuleGroupRulesSource,
    public val statefulRuleOptions: RuleGroupRuleGroupStatefulRuleOptions? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.networkfirewall.outputs.RuleGroupRuleGroup):
            RuleGroupRuleGroup = RuleGroupRuleGroup(
            referenceSets = javaType.referenceSets().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.networkfirewall.kotlin.outputs.RuleGroupRuleGroupReferenceSets.Companion.toKotlin(args0)
                })
            }).orElse(null),
            ruleVariables = javaType.ruleVariables().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.networkfirewall.kotlin.outputs.RuleGroupRuleGroupRuleVariables.Companion.toKotlin(args0)
                })
            }).orElse(null),
            rulesSource = javaType.rulesSource().let({ args0 ->
                com.pulumi.aws.networkfirewall.kotlin.outputs.RuleGroupRuleGroupRulesSource.Companion.toKotlin(args0)
            }),
            statefulRuleOptions = javaType.statefulRuleOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.networkfirewall.kotlin.outputs.RuleGroupRuleGroupStatefulRuleOptions.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
