@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property ipSetReferences Set of configuration blocks that define the IP Reference information. See IP Set Reference below for details.
 * @property key A unique alphanumeric string to identify the `ip_set`.
 */
public data class RuleGroupRuleGroupReferenceSetsIpSetReference(
    public val ipSetReferences: List<RuleGroupRuleGroupReferenceSetsIpSetReferenceIpSetReference>,
    public val key: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.networkfirewall.outputs.RuleGroupRuleGroupReferenceSetsIpSetReference):
            RuleGroupRuleGroupReferenceSetsIpSetReference =
            RuleGroupRuleGroupReferenceSetsIpSetReference(
                ipSetReferences = javaType.ipSetReferences().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.networkfirewall.kotlin.outputs.RuleGroupRuleGroupReferenceSetsIpSetReferenceIpSetReference.Companion.toKotlin(args0)
                    })
                }),
                key = javaType.key(),
            )
    }
}
