@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property rulesSourceList A configuration block containing **stateful** inspection criteria for a domain list rule group. See Rules Source List below for details.
 * @property rulesString The fully qualified name of a file in an S3 bucket that contains Suricata compatible intrusion preventions system (IPS) rules or the Suricata rules as a string. These rules contain **stateful** inspection criteria and the action to take for traffic that matches the criteria.
 * @property statefulRules Set of configuration blocks containing **stateful** inspection criteria for 5-tuple rules to be used together in a rule group. See Stateful Rule below for details.
 * @property statelessRulesAndCustomActions A configuration block containing **stateless** inspection criteria for a stateless rule group. See Stateless Rules and Custom Actions below for details.
 */
public data class RuleGroupRuleGroupRulesSource(
    public val rulesSourceList: RuleGroupRuleGroupRulesSourceRulesSourceList? = null,
    public val rulesString: String? = null,
    public val statefulRules: List<RuleGroupRuleGroupRulesSourceStatefulRule>? = null,
    public val statelessRulesAndCustomActions:
    RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActions? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.networkfirewall.outputs.RuleGroupRuleGroupRulesSource):
            RuleGroupRuleGroupRulesSource = RuleGroupRuleGroupRulesSource(
            rulesSourceList = javaType.rulesSourceList().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.networkfirewall.kotlin.outputs.RuleGroupRuleGroupRulesSourceRulesSourceList.Companion.toKotlin(args0)
                })
            }).orElse(null),
            rulesString = javaType.rulesString().map({ args0 -> args0 }).orElse(null),
            statefulRules = javaType.statefulRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.networkfirewall.kotlin.outputs.RuleGroupRuleGroupRulesSourceStatefulRule.Companion.toKotlin(args0)
                })
            }),
            statelessRulesAndCustomActions = javaType.statelessRulesAndCustomActions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.networkfirewall.kotlin.outputs.RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActions.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
