@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property generatedRulesType String value to specify whether domains in the target list are allowed or denied access. Valid values: `ALLOWLIST`, `DENYLIST`.
 * @property targetTypes Set of types of domain specifications that are provided in the `targets` argument. Valid values: `HTTP_HOST`, `TLS_SNI`.
 * @property targets Set of domains that you want to inspect for in your traffic flows.
 */
public data class RuleGroupRuleGroupRulesSourceRulesSourceList(
    public val generatedRulesType: String,
    public val targetTypes: List<String>,
    public val targets: List<String>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.networkfirewall.outputs.RuleGroupRuleGroupRulesSourceRulesSourceList):
            RuleGroupRuleGroupRulesSourceRulesSourceList = RuleGroupRuleGroupRulesSourceRulesSourceList(
            generatedRulesType = javaType.generatedRulesType(),
            targetTypes = javaType.targetTypes().map({ args0 -> args0 }),
            targets = javaType.targets().map({ args0 -> args0 }),
        )
    }
}
