@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property keyword Keyword defined by open source detection systems like Snort or Suricata for stateful rule inspection.
 * See [Snort General Rule Options](http://manual-snort-org&#46;s3-website-us-east-1&#46;amazonaws&#46;com/node31&#46;html) or [Suricata Rule Options](https://suricata.readthedocs.io/en/suricata-5.0.1/rules/intro.html#rule-options) for more details.
 * @property settings Set of strings for additional settings to use in stateful rule inspection.
 */
public data class RuleGroupRuleGroupRulesSourceStatefulRuleRuleOption(
    public val keyword: String,
    public val settings: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.networkfirewall.outputs.RuleGroupRuleGroupRulesSourceStatefulRuleRuleOption):
            RuleGroupRuleGroupRulesSourceStatefulRuleRuleOption =
            RuleGroupRuleGroupRulesSourceStatefulRuleRuleOption(
                keyword = javaType.keyword(),
                settings = javaType.settings().map({ args0 -> args0 }),
            )
    }
}
