@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkfirewall.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property priority A setting that indicates the order in which to run this rule relative to all of the rules that are defined for a stateless rule group. AWS Network Firewall evaluates the rules in a rule group starting with the lowest priority setting.
 * @property ruleDefinition A configuration block defining the stateless 5-tuple packet inspection criteria and the action to take on a packet that matches the criteria. See Rule Definition below for details.
 */
public data class RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsStatelessRule(
    public val priority: Int,
    public val ruleDefinition:
    RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsStatelessRuleRuleDefinition,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.networkfirewall.outputs.RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsStatelessRule):
            RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsStatelessRule =
            RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsStatelessRule(
                priority = javaType.priority(),
                ruleDefinition = javaType.ruleDefinition().let({ args0 ->
                    com.pulumi.aws.networkfirewall.kotlin.outputs.RuleGroupRuleGroupRulesSourceStatelessRulesAndCustomActionsStatelessRuleRuleDefinition.Companion.toKotlin(args0)
                }),
            )
    }
}
