@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [AttachmentAccepter].
 */
@PulumiTagMarker
public class AttachmentAccepterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AttachmentAccepterArgs = AttachmentAccepterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AttachmentAccepterArgsBuilder.() -> Unit) {
        val builder = AttachmentAccepterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): AttachmentAccepter {
        val builtJavaResource =
            com.pulumi.aws.networkmanager.AttachmentAccepter(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return AttachmentAccepter(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS Network Manager Attachment Accepter.
 * ## Example Usage
 * ### Example with VPC attachment
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkmanager.AttachmentAccepter;
 * import com.pulumi.aws.networkmanager.AttachmentAccepterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new AttachmentAccepter("test", AttachmentAccepterArgs.builder()
 *             .attachmentId(aws_networkmanager_vpc_attachment.vpc().id())
 *             .attachmentType(aws_networkmanager_vpc_attachment.vpc().attachment_type())
 *             .build());
 *     }
 * }
 * ```
 * ### Example with site-to-site VPN attachment
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkmanager.AttachmentAccepter;
 * import com.pulumi.aws.networkmanager.AttachmentAccepterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new AttachmentAccepter("test", AttachmentAccepterArgs.builder()
 *             .attachmentId(aws_networkmanager_site_to_site_vpn_attachment.vpn().id())
 *             .attachmentType(aws_networkmanager_site_to_site_vpn_attachment.vpn().attachment_type())
 *             .build());
 *     }
 * }
 * ```
 */
public class AttachmentAccepter internal constructor(
    override val javaResource: com.pulumi.aws.networkmanager.AttachmentAccepter,
) : KotlinCustomResource(javaResource, AttachmentAccepterMapper) {
    /**
     * The ID of the attachment.
     */
    public val attachmentId: Output<String>
        get() = javaResource.attachmentId().applyValue({ args0 -> args0 })

    /**
     * The policy rule number associated with the attachment.
     */
    public val attachmentPolicyRuleNumber: Output<Int>
        get() = javaResource.attachmentPolicyRuleNumber().applyValue({ args0 -> args0 })

    /**
     * The type of attachment. Valid values can be found in the [AWS Documentation](https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_ListAttachments.html#API_ListAttachments_RequestSyntax)
     */
    public val attachmentType: Output<String>
        get() = javaResource.attachmentType().applyValue({ args0 -> args0 })

    /**
     * The ARN of a core network.
     */
    public val coreNetworkArn: Output<String>
        get() = javaResource.coreNetworkArn().applyValue({ args0 -> args0 })

    /**
     * The id of a core network.
     */
    public val coreNetworkId: Output<String>
        get() = javaResource.coreNetworkId().applyValue({ args0 -> args0 })

    /**
     * The Region where the edge is located.
     */
    public val edgeLocation: Output<String>
        get() = javaResource.edgeLocation().applyValue({ args0 -> args0 })

    /**
     * The ID of the attachment account owner.
     */
    public val ownerAccountId: Output<String>
        get() = javaResource.ownerAccountId().applyValue({ args0 -> args0 })

    /**
     * The attachment resource ARN.
     */
    public val resourceArn: Output<String>
        get() = javaResource.resourceArn().applyValue({ args0 -> args0 })

    /**
     * The name of the segment attachment.
     */
    public val segmentName: Output<String>
        get() = javaResource.segmentName().applyValue({ args0 -> args0 })

    /**
     * The state of the attachment.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })
}

public object AttachmentAccepterMapper : ResourceMapper<AttachmentAccepter> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.networkmanager.AttachmentAccepter::class == javaResource::class

    override fun map(javaResource: Resource): AttachmentAccepter = AttachmentAccepter(
        javaResource as
            com.pulumi.aws.networkmanager.AttachmentAccepter,
    )
}

/**
 * @see [AttachmentAccepter].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AttachmentAccepter].
 */
public suspend fun attachmentAccepter(
    name: String,
    block: suspend AttachmentAccepterResourceBuilder.() -> Unit,
): AttachmentAccepter {
    val builder = AttachmentAccepterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AttachmentAccepter].
 * @param name The _unique_ name of the resulting resource.
 */
public fun attachmentAccepter(name: String): AttachmentAccepter {
    val builder = AttachmentAccepterResourceBuilder()
    builder.name(name)
    return builder.build()
}
