@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin

import com.pulumi.aws.networkmanager.AttachmentAccepterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Network Manager Attachment Accepter.
 * ## Example Usage
 * ### Example with VPC attachment
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkmanager.AttachmentAccepter;
 * import com.pulumi.aws.networkmanager.AttachmentAccepterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new AttachmentAccepter("test", AttachmentAccepterArgs.builder()
 *             .attachmentId(aws_networkmanager_vpc_attachment.vpc().id())
 *             .attachmentType(aws_networkmanager_vpc_attachment.vpc().attachment_type())
 *             .build());
 *     }
 * }
 * ```
 * ### Example with site-to-site VPN attachment
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkmanager.AttachmentAccepter;
 * import com.pulumi.aws.networkmanager.AttachmentAccepterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new AttachmentAccepter("test", AttachmentAccepterArgs.builder()
 *             .attachmentId(aws_networkmanager_site_to_site_vpn_attachment.vpn().id())
 *             .attachmentType(aws_networkmanager_site_to_site_vpn_attachment.vpn().attachment_type())
 *             .build());
 *     }
 * }
 * ```
 * @property attachmentId The ID of the attachment.
 * @property attachmentType The type of attachment. Valid values can be found in the [AWS Documentation](https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_ListAttachments.html#API_ListAttachments_RequestSyntax)
 */
public data class AttachmentAccepterArgs(
    public val attachmentId: Output<String>? = null,
    public val attachmentType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.networkmanager.AttachmentAccepterArgs> {
    override fun toJava(): com.pulumi.aws.networkmanager.AttachmentAccepterArgs =
        com.pulumi.aws.networkmanager.AttachmentAccepterArgs.builder()
            .attachmentId(attachmentId?.applyValue({ args0 -> args0 }))
            .attachmentType(attachmentType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AttachmentAccepterArgs].
 */
@PulumiTagMarker
public class AttachmentAccepterArgsBuilder internal constructor() {
    private var attachmentId: Output<String>? = null

    private var attachmentType: Output<String>? = null

    /**
     * @param value The ID of the attachment.
     */
    @JvmName("qyrebnlvlhlkmonw")
    public suspend fun attachmentId(`value`: Output<String>) {
        this.attachmentId = value
    }

    /**
     * @param value The type of attachment. Valid values can be found in the [AWS Documentation](https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_ListAttachments.html#API_ListAttachments_RequestSyntax)
     */
    @JvmName("enicvhoihapakuaq")
    public suspend fun attachmentType(`value`: Output<String>) {
        this.attachmentType = value
    }

    /**
     * @param value The ID of the attachment.
     */
    @JvmName("arvpnctmhenhgdwr")
    public suspend fun attachmentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.attachmentId = mapped
    }

    /**
     * @param value The type of attachment. Valid values can be found in the [AWS Documentation](https://docs.aws.amazon.com/networkmanager/latest/APIReference/API_ListAttachments.html#API_ListAttachments_RequestSyntax)
     */
    @JvmName("oskdyeelipituxeh")
    public suspend fun attachmentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.attachmentType = mapped
    }

    internal fun build(): AttachmentAccepterArgs = AttachmentAccepterArgs(
        attachmentId = attachmentId,
        attachmentType = attachmentType,
    )
}
