@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin

import com.pulumi.aws.networkmanager.ConnectAttachmentArgs.builder
import com.pulumi.aws.networkmanager.kotlin.inputs.ConnectAttachmentOptionsArgs
import com.pulumi.aws.networkmanager.kotlin.inputs.ConnectAttachmentOptionsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Network Manager ConnectAttachment.
 * {{% examples %}}
 * ## Example Usage
 * {{% /examples %}}
 * ## Import
 * Using `pulumi import`, import `aws_networkmanager_connect_attachment` using the attachment ID. For example:
 * ```sh
 *  $ pulumi import aws:networkmanager/connectAttachment:ConnectAttachment example attachment-0f8fa60d2238d1bd8
 * ```
 * @property coreNetworkId The ID of a core network where you want to create the attachment.
 * @property edgeLocation The Region where the edge is located.
 * @property options Options block. See options for more information.
 * The following arguments are optional:
 * @property tags Key-value tags for the attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property transportAttachmentId The ID of the attachment between the two connections.
 */
public data class ConnectAttachmentArgs(
    public val coreNetworkId: Output<String>? = null,
    public val edgeLocation: Output<String>? = null,
    public val options: Output<ConnectAttachmentOptionsArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val transportAttachmentId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.networkmanager.ConnectAttachmentArgs> {
    override fun toJava(): com.pulumi.aws.networkmanager.ConnectAttachmentArgs =
        com.pulumi.aws.networkmanager.ConnectAttachmentArgs.builder()
            .coreNetworkId(coreNetworkId?.applyValue({ args0 -> args0 }))
            .edgeLocation(edgeLocation?.applyValue({ args0 -> args0 }))
            .options(options?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .transportAttachmentId(transportAttachmentId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectAttachmentArgs].
 */
@PulumiTagMarker
public class ConnectAttachmentArgsBuilder internal constructor() {
    private var coreNetworkId: Output<String>? = null

    private var edgeLocation: Output<String>? = null

    private var options: Output<ConnectAttachmentOptionsArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var transportAttachmentId: Output<String>? = null

    /**
     * @param value The ID of a core network where you want to create the attachment.
     */
    @JvmName("pfjbmjvnlndbxkov")
    public suspend fun coreNetworkId(`value`: Output<String>) {
        this.coreNetworkId = value
    }

    /**
     * @param value The Region where the edge is located.
     */
    @JvmName("luwswtymedoiwhgq")
    public suspend fun edgeLocation(`value`: Output<String>) {
        this.edgeLocation = value
    }

    /**
     * @param value Options block. See options for more information.
     * The following arguments are optional:
     */
    @JvmName("iwpkrdillorrsada")
    public suspend fun options(`value`: Output<ConnectAttachmentOptionsArgs>) {
        this.options = value
    }

    /**
     * @param value Key-value tags for the attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ashwisnlvlavkpvt")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The ID of the attachment between the two connections.
     */
    @JvmName("oaaxmctfhaaslamm")
    public suspend fun transportAttachmentId(`value`: Output<String>) {
        this.transportAttachmentId = value
    }

    /**
     * @param value The ID of a core network where you want to create the attachment.
     */
    @JvmName("wrgwgoslgwfcdlfp")
    public suspend fun coreNetworkId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.coreNetworkId = mapped
    }

    /**
     * @param value The Region where the edge is located.
     */
    @JvmName("tyvocpmfleokuyxa")
    public suspend fun edgeLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.edgeLocation = mapped
    }

    /**
     * @param value Options block. See options for more information.
     * The following arguments are optional:
     */
    @JvmName("cyfsnvpifsaxbhje")
    public suspend fun options(`value`: ConnectAttachmentOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.options = mapped
    }

    /**
     * @param argument Options block. See options for more information.
     * The following arguments are optional:
     */
    @JvmName("todoyfsnuxrjifiy")
    public suspend fun options(argument: suspend ConnectAttachmentOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = ConnectAttachmentOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.options = mapped
    }

    /**
     * @param value Key-value tags for the attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("pkyhistrmlaagcfl")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value tags for the attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("jvjnfuavmgtdsfat")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The ID of the attachment between the two connections.
     */
    @JvmName("oaucywwigyyenwvw")
    public suspend fun transportAttachmentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transportAttachmentId = mapped
    }

    internal fun build(): ConnectAttachmentArgs = ConnectAttachmentArgs(
        coreNetworkId = coreNetworkId,
        edgeLocation = edgeLocation,
        options = options,
        tags = tags,
        transportAttachmentId = transportAttachmentId,
    )
}
