@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin

import com.pulumi.aws.networkmanager.kotlin.outputs.ConnectPeerBgpOptions
import com.pulumi.aws.networkmanager.kotlin.outputs.ConnectPeerConfiguration
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.networkmanager.kotlin.outputs.ConnectPeerBgpOptions.Companion.toKotlin as connectPeerBgpOptionsToKotlin
import com.pulumi.aws.networkmanager.kotlin.outputs.ConnectPeerConfiguration.Companion.toKotlin as connectPeerConfigurationToKotlin

/**
 * Builder for [ConnectPeer].
 */
@PulumiTagMarker
public class ConnectPeerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ConnectPeerArgs = ConnectPeerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ConnectPeerArgsBuilder.() -> Unit) {
        val builder = ConnectPeerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ConnectPeer {
        val builtJavaResource = com.pulumi.aws.networkmanager.ConnectPeer(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ConnectPeer(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS Network Manager Connect Peer.
 * {{% examples %}}
 * ## Example Usage
 * {{% /examples %}}
 * ## Import
 * Using `pulumi import`, import `aws_networkmanager_connect_peer` using the connect peer ID. For example:
 * ```sh
 *  $ pulumi import aws:networkmanager/connectPeer:ConnectPeer example connect-peer-061f3e96275db1acc
 * ```
 *
 */
public class ConnectPeer internal constructor(
    override val javaResource: com.pulumi.aws.networkmanager.ConnectPeer,
) : KotlinCustomResource(javaResource, ConnectPeerMapper) {
    /**
     * The ARN of the attachment.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The Connect peer BGP options.
     */
    public val bgpOptions: Output<ConnectPeerBgpOptions>?
        get() = javaResource.bgpOptions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    connectPeerBgpOptionsToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The configuration of the Connect peer.
     */
    public val configurations: Output<List<ConnectPeerConfiguration>>
        get() = javaResource.configurations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> connectPeerConfigurationToKotlin(args0) })
            })
        })

    /**
     * The ID of the connection attachment.
     */
    public val connectAttachmentId: Output<String>
        get() = javaResource.connectAttachmentId().applyValue({ args0 -> args0 })

    public val connectPeerId: Output<String>
        get() = javaResource.connectPeerId().applyValue({ args0 -> args0 })

    /**
     * A Connect peer core network address.
     */
    public val coreNetworkAddress: Output<String>?
        get() = javaResource.coreNetworkAddress().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of a core network.
     */
    public val coreNetworkId: Output<String>
        get() = javaResource.coreNetworkId().applyValue({ args0 -> args0 })

    public val createdAt: Output<String>
        get() = javaResource.createdAt().applyValue({ args0 -> args0 })

    /**
     * The Region where the peer is located.
     */
    public val edgeLocation: Output<String>
        get() = javaResource.edgeLocation().applyValue({ args0 -> args0 })

    /**
     * The inside IP addresses used for BGP peering. Required when the Connect attachment protocol is `GRE`. See `aws.networkmanager.ConnectAttachment` for details.
     */
    public val insideCidrBlocks: Output<List<String>>?
        get() = javaResource.insideCidrBlocks().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The Connect peer address.
     * The following arguments are optional:
     */
    public val peerAddress: Output<String>
        get() = javaResource.peerAddress().applyValue({ args0 -> args0 })

    /**
     * The state of the Connect peer.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * The subnet ARN for the Connect peer. Required when the Connect attachment protocol is `NO_ENCAP`. See `aws.networkmanager.ConnectAttachment` for details.
     */
    public val subnetArn: Output<String>?
        get() = javaResource.subnetArn().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Key-value tags for the attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object ConnectPeerMapper : ResourceMapper<ConnectPeer> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.networkmanager.ConnectPeer::class == javaResource::class

    override fun map(javaResource: Resource): ConnectPeer = ConnectPeer(
        javaResource as
            com.pulumi.aws.networkmanager.ConnectPeer,
    )
}

/**
 * @see [ConnectPeer].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ConnectPeer].
 */
public suspend fun connectPeer(name: String, block: suspend ConnectPeerResourceBuilder.() -> Unit):
    ConnectPeer {
    val builder = ConnectPeerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ConnectPeer].
 * @param name The _unique_ name of the resulting resource.
 */
public fun connectPeer(name: String): ConnectPeer {
    val builder = ConnectPeerResourceBuilder()
    builder.name(name)
    return builder.build()
}
