@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin

import com.pulumi.aws.networkmanager.ConnectPeerArgs.builder
import com.pulumi.aws.networkmanager.kotlin.inputs.ConnectPeerBgpOptionsArgs
import com.pulumi.aws.networkmanager.kotlin.inputs.ConnectPeerBgpOptionsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Network Manager Connect Peer.
 * {{% examples %}}
 * ## Example Usage
 * {{% /examples %}}
 * ## Import
 * Using `pulumi import`, import `aws_networkmanager_connect_peer` using the connect peer ID. For example:
 * ```sh
 *  $ pulumi import aws:networkmanager/connectPeer:ConnectPeer example connect-peer-061f3e96275db1acc
 * ```
 * @property bgpOptions The Connect peer BGP options.
 * @property connectAttachmentId The ID of the connection attachment.
 * @property coreNetworkAddress A Connect peer core network address.
 * @property insideCidrBlocks The inside IP addresses used for BGP peering. Required when the Connect attachment protocol is `GRE`. See `aws.networkmanager.ConnectAttachment` for details.
 * @property peerAddress The Connect peer address.
 * The following arguments are optional:
 * @property subnetArn The subnet ARN for the Connect peer. Required when the Connect attachment protocol is `NO_ENCAP`. See `aws.networkmanager.ConnectAttachment` for details.
 * @property tags Key-value tags for the attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class ConnectPeerArgs(
    public val bgpOptions: Output<ConnectPeerBgpOptionsArgs>? = null,
    public val connectAttachmentId: Output<String>? = null,
    public val coreNetworkAddress: Output<String>? = null,
    public val insideCidrBlocks: Output<List<String>>? = null,
    public val peerAddress: Output<String>? = null,
    public val subnetArn: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.networkmanager.ConnectPeerArgs> {
    override fun toJava(): com.pulumi.aws.networkmanager.ConnectPeerArgs =
        com.pulumi.aws.networkmanager.ConnectPeerArgs.builder()
            .bgpOptions(bgpOptions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .connectAttachmentId(connectAttachmentId?.applyValue({ args0 -> args0 }))
            .coreNetworkAddress(coreNetworkAddress?.applyValue({ args0 -> args0 }))
            .insideCidrBlocks(insideCidrBlocks?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .peerAddress(peerAddress?.applyValue({ args0 -> args0 }))
            .subnetArn(subnetArn?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ConnectPeerArgs].
 */
@PulumiTagMarker
public class ConnectPeerArgsBuilder internal constructor() {
    private var bgpOptions: Output<ConnectPeerBgpOptionsArgs>? = null

    private var connectAttachmentId: Output<String>? = null

    private var coreNetworkAddress: Output<String>? = null

    private var insideCidrBlocks: Output<List<String>>? = null

    private var peerAddress: Output<String>? = null

    private var subnetArn: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The Connect peer BGP options.
     */
    @JvmName("dwbchbyudbftgxkv")
    public suspend fun bgpOptions(`value`: Output<ConnectPeerBgpOptionsArgs>) {
        this.bgpOptions = value
    }

    /**
     * @param value The ID of the connection attachment.
     */
    @JvmName("xrnlfkswbhurtxfp")
    public suspend fun connectAttachmentId(`value`: Output<String>) {
        this.connectAttachmentId = value
    }

    /**
     * @param value A Connect peer core network address.
     */
    @JvmName("opisuetpubipsxtp")
    public suspend fun coreNetworkAddress(`value`: Output<String>) {
        this.coreNetworkAddress = value
    }

    /**
     * @param value The inside IP addresses used for BGP peering. Required when the Connect attachment protocol is `GRE`. See `aws.networkmanager.ConnectAttachment` for details.
     */
    @JvmName("ytcilbmnymqonrxv")
    public suspend fun insideCidrBlocks(`value`: Output<List<String>>) {
        this.insideCidrBlocks = value
    }

    @JvmName("kndfoikcoonotpie")
    public suspend fun insideCidrBlocks(vararg values: Output<String>) {
        this.insideCidrBlocks = Output.all(values.asList())
    }

    /**
     * @param values The inside IP addresses used for BGP peering. Required when the Connect attachment protocol is `GRE`. See `aws.networkmanager.ConnectAttachment` for details.
     */
    @JvmName("gewbfwwaswatbkxw")
    public suspend fun insideCidrBlocks(values: List<Output<String>>) {
        this.insideCidrBlocks = Output.all(values)
    }

    /**
     * @param value The Connect peer address.
     * The following arguments are optional:
     */
    @JvmName("cokaptndwxfwcfsr")
    public suspend fun peerAddress(`value`: Output<String>) {
        this.peerAddress = value
    }

    /**
     * @param value The subnet ARN for the Connect peer. Required when the Connect attachment protocol is `NO_ENCAP`. See `aws.networkmanager.ConnectAttachment` for details.
     */
    @JvmName("xbabhkkkgromjggh")
    public suspend fun subnetArn(`value`: Output<String>) {
        this.subnetArn = value
    }

    /**
     * @param value Key-value tags for the attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("gmdxikvarypeegon")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The Connect peer BGP options.
     */
    @JvmName("desgbtpofrgtlpqa")
    public suspend fun bgpOptions(`value`: ConnectPeerBgpOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bgpOptions = mapped
    }

    /**
     * @param argument The Connect peer BGP options.
     */
    @JvmName("avccclhvgowdwxup")
    public suspend fun bgpOptions(argument: suspend ConnectPeerBgpOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = ConnectPeerBgpOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.bgpOptions = mapped
    }

    /**
     * @param value The ID of the connection attachment.
     */
    @JvmName("pvnyabhowgnphpln")
    public suspend fun connectAttachmentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectAttachmentId = mapped
    }

    /**
     * @param value A Connect peer core network address.
     */
    @JvmName("yvxinvbicsygtirx")
    public suspend fun coreNetworkAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.coreNetworkAddress = mapped
    }

    /**
     * @param value The inside IP addresses used for BGP peering. Required when the Connect attachment protocol is `GRE`. See `aws.networkmanager.ConnectAttachment` for details.
     */
    @JvmName("uxticujwukicagur")
    public suspend fun insideCidrBlocks(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.insideCidrBlocks = mapped
    }

    /**
     * @param values The inside IP addresses used for BGP peering. Required when the Connect attachment protocol is `GRE`. See `aws.networkmanager.ConnectAttachment` for details.
     */
    @JvmName("yhuygycjbpdapejr")
    public suspend fun insideCidrBlocks(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.insideCidrBlocks = mapped
    }

    /**
     * @param value The Connect peer address.
     * The following arguments are optional:
     */
    @JvmName("fodkcteghcqvjorg")
    public suspend fun peerAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peerAddress = mapped
    }

    /**
     * @param value The subnet ARN for the Connect peer. Required when the Connect attachment protocol is `NO_ENCAP`. See `aws.networkmanager.ConnectAttachment` for details.
     */
    @JvmName("qxdgkfggnndhsjbl")
    public suspend fun subnetArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetArn = mapped
    }

    /**
     * @param value Key-value tags for the attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("fixqbdxwkempfwnv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value tags for the attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("bivlgmtbybhpsxjo")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ConnectPeerArgs = ConnectPeerArgs(
        bgpOptions = bgpOptions,
        connectAttachmentId = connectAttachmentId,
        coreNetworkAddress = coreNetworkAddress,
        insideCidrBlocks = insideCidrBlocks,
        peerAddress = peerAddress,
        subnetArn = subnetArn,
        tags = tags,
    )
}
