@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin

import com.pulumi.aws.networkmanager.kotlin.outputs.CoreNetworkEdge
import com.pulumi.aws.networkmanager.kotlin.outputs.CoreNetworkSegment
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.networkmanager.kotlin.outputs.CoreNetworkEdge.Companion.toKotlin as coreNetworkEdgeToKotlin
import com.pulumi.aws.networkmanager.kotlin.outputs.CoreNetworkSegment.Companion.toKotlin as coreNetworkSegmentToKotlin

/**
 * Builder for [CoreNetwork].
 */
@PulumiTagMarker
public class CoreNetworkResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CoreNetworkArgs = CoreNetworkArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CoreNetworkArgsBuilder.() -> Unit) {
        val builder = CoreNetworkArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): CoreNetwork {
        val builtJavaResource = com.pulumi.aws.networkmanager.CoreNetwork(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return CoreNetwork(builtJavaResource)
    }
}

/**
 * Provides a core network resource.
 * ## Example Usage
 * ### Basic
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkmanager.CoreNetwork;
 * import com.pulumi.aws.networkmanager.CoreNetworkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new CoreNetwork("example", CoreNetworkArgs.builder()
 *             .globalNetworkId(aws_networkmanager_global_network.example().id())
 *             .build());
 *     }
 * }
 * ```
 * ### With description
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkmanager.CoreNetwork;
 * import com.pulumi.aws.networkmanager.CoreNetworkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new CoreNetwork("example", CoreNetworkArgs.builder()
 *             .globalNetworkId(aws_networkmanager_global_network.example().id())
 *             .description("example")
 *             .build());
 *     }
 * }
 * ```
 * ### With tags
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkmanager.CoreNetwork;
 * import com.pulumi.aws.networkmanager.CoreNetworkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new CoreNetwork("example", CoreNetworkArgs.builder()
 *             .globalNetworkId(aws_networkmanager_global_network.example().id())
 *             .tags(Map.of("hello", "world"))
 *             .build());
 *     }
 * }
 * ```
 * ### Option 1 - using base_policy_document
 * If you require a custom ASN for the edge location, please use the `base_policy_document` argument to pass a specific ASN. For example:
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkmanager.GlobalNetwork;
 * import com.pulumi.aws.networkmanager.NetworkmanagerFunctions;
 * import com.pulumi.aws.networkmanager.inputs.GetCoreNetworkPolicyDocumentArgs;
 * import com.pulumi.aws.networkmanager.CoreNetwork;
 * import com.pulumi.aws.networkmanager.CoreNetworkArgs;
 * import com.pulumi.aws.networkmanager.VpcAttachment;
 * import com.pulumi.aws.networkmanager.VpcAttachmentArgs;
 * import com.pulumi.aws.networkmanager.CoreNetworkPolicyAttachment;
 * import com.pulumi.aws.networkmanager.CoreNetworkPolicyAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleGlobalNetwork = new GlobalNetwork("exampleGlobalNetwork");
 *         final var base = NetworkmanagerFunctions.getCoreNetworkPolicyDocument(GetCoreNetworkPolicyDocumentArgs.builder()
 *             .coreNetworkConfigurations(GetCoreNetworkPolicyDocumentCoreNetworkConfigurationArgs.builder()
 *                 .asnRanges("65022-65534")
 *                 .edgeLocations(GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocationArgs.builder()
 *                     .location("us-west-2")
 *                     .asn("65500")
 *                     .build())
 *                 .build())
 *             .segments(GetCoreNetworkPolicyDocumentSegmentArgs.builder()
 *                 .name("segment")
 *                 .build())
 *             .build());
 *         var exampleCoreNetwork = new CoreNetwork("exampleCoreNetwork", CoreNetworkArgs.builder()
 *             .globalNetworkId(exampleGlobalNetwork.id())
 *             .basePolicyDocument(base.applyValue(getCoreNetworkPolicyDocumentResult -> getCoreNetworkPolicyDocumentResult.json()))
 *             .createBasePolicy(true)
 *             .build());
 *         var exampleVpcAttachment = new VpcAttachment("exampleVpcAttachment", VpcAttachmentArgs.builder()
 *             .coreNetworkId(exampleCoreNetwork.id())
 *             .subnetArns(aws_subnet.example().stream().map(element -> element.arn()).collect(toList()))
 *             .vpcArn(aws_vpc.example().arn())
 *             .build());
 *         final var exampleCoreNetworkPolicyDocument = NetworkmanagerFunctions.getCoreNetworkPolicyDocument(GetCoreNetworkPolicyDocumentArgs.builder()
 *             .coreNetworkConfigurations(GetCoreNetworkPolicyDocumentCoreNetworkConfigurationArgs.builder()
 *                 .asnRanges("65022-65534")
 *                 .edgeLocations(GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocationArgs.builder()
 *                     .location("us-west-2")
 *                     .asn("65500")
 *                     .build())
 *                 .build())
 *             .segments(GetCoreNetworkPolicyDocumentSegmentArgs.builder()
 *                 .name("segment")
 *                 .build())
 *             .segmentActions(GetCoreNetworkPolicyDocumentSegmentActionArgs.builder()
 *                 .action("create-route")
 *                 .segment("segment")
 *                 .destinationCidrBlocks("0.0.0.0/0")
 *                 .destinations(exampleVpcAttachment.id())
 *                 .build())
 *             .build());
 *         var exampleCoreNetworkPolicyAttachment = new CoreNetworkPolicyAttachment("exampleCoreNetworkPolicyAttachment", CoreNetworkPolicyAttachmentArgs.builder()
 *             .coreNetworkId(exampleCoreNetwork.id())
 *             .policyDocument(exampleCoreNetworkPolicyDocument.applyValue(getCoreNetworkPolicyDocumentResult -> getCoreNetworkPolicyDocumentResult).applyValue(exampleCoreNetworkPolicyDocument -> exampleCoreNetworkPolicyDocument.applyValue(getCoreNetworkPolicyDocumentResult -> getCoreNetworkPolicyDocumentResult.json())))
 *             .build());
 *     }
 * }
 * ```
 * ### Option 2 - create_base_policy only
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkmanager.GlobalNetwork;
 * import com.pulumi.aws.networkmanager.CoreNetwork;
 * import com.pulumi.aws.networkmanager.CoreNetworkArgs;
 * import com.pulumi.aws.networkmanager.VpcAttachment;
 * import com.pulumi.aws.networkmanager.VpcAttachmentArgs;
 * import com.pulumi.aws.networkmanager.NetworkmanagerFunctions;
 * import com.pulumi.aws.networkmanager.inputs.GetCoreNetworkPolicyDocumentArgs;
 * import com.pulumi.aws.networkmanager.CoreNetworkPolicyAttachment;
 * import com.pulumi.aws.networkmanager.CoreNetworkPolicyAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleGlobalNetwork = new GlobalNetwork("exampleGlobalNetwork");
 *         var exampleCoreNetwork = new CoreNetwork("exampleCoreNetwork", CoreNetworkArgs.builder()
 *             .globalNetworkId(exampleGlobalNetwork.id())
 *             .createBasePolicy(true)
 *             .build());
 *         var exampleVpcAttachment = new VpcAttachment("exampleVpcAttachment", VpcAttachmentArgs.builder()
 *             .coreNetworkId(exampleCoreNetwork.id())
 *             .subnetArns(aws_subnet.example().stream().map(element -> element.arn()).collect(toList()))
 *             .vpcArn(aws_vpc.example().arn())
 *             .build());
 *         final var exampleCoreNetworkPolicyDocument = NetworkmanagerFunctions.getCoreNetworkPolicyDocument(GetCoreNetworkPolicyDocumentArgs.builder()
 *             .coreNetworkConfigurations(GetCoreNetworkPolicyDocumentCoreNetworkConfigurationArgs.builder()
 *                 .asnRanges("65022-65534")
 *                 .edgeLocations(GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocationArgs.builder()
 *                     .location("us-west-2")
 *                     .build())
 *                 .build())
 *             .segments(GetCoreNetworkPolicyDocumentSegmentArgs.builder()
 *                 .name("segment")
 *                 .build())
 *             .segmentActions(GetCoreNetworkPolicyDocumentSegmentActionArgs.builder()
 *                 .action("create-route")
 *                 .segment("segment")
 *                 .destinationCidrBlocks("0.0.0.0/0")
 *                 .destinations(exampleVpcAttachment.id())
 *                 .build())
 *             .build());
 *         var exampleCoreNetworkPolicyAttachment = new CoreNetworkPolicyAttachment("exampleCoreNetworkPolicyAttachment", CoreNetworkPolicyAttachmentArgs.builder()
 *             .coreNetworkId(exampleCoreNetwork.id())
 *             .policyDocument(exampleCoreNetworkPolicyDocument.applyValue(getCoreNetworkPolicyDocumentResult -> getCoreNetworkPolicyDocumentResult).applyValue(exampleCoreNetworkPolicyDocument -> exampleCoreNetworkPolicyDocument.applyValue(getCoreNetworkPolicyDocumentResult -> getCoreNetworkPolicyDocumentResult.json())))
 *             .build());
 *     }
 * }
 * ```
 * ### Option 1 - using base_policy_document
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkmanager.GlobalNetwork;
 * import com.pulumi.aws.networkmanager.NetworkmanagerFunctions;
 * import com.pulumi.aws.networkmanager.inputs.GetCoreNetworkPolicyDocumentArgs;
 * import com.pulumi.aws.networkmanager.CoreNetwork;
 * import com.pulumi.aws.networkmanager.CoreNetworkArgs;
 * import com.pulumi.aws.networkmanager.VpcAttachment;
 * import com.pulumi.aws.networkmanager.VpcAttachmentArgs;
 * import com.pulumi.aws.networkmanager.CoreNetworkPolicyAttachment;
 * import com.pulumi.aws.networkmanager.CoreNetworkPolicyAttachmentArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleGlobalNetwork = new GlobalNetwork("exampleGlobalNetwork");
 *         final var base = NetworkmanagerFunctions.getCoreNetworkPolicyDocument(GetCoreNetworkPolicyDocumentArgs.builder()
 *             .coreNetworkConfigurations(GetCoreNetworkPolicyDocumentCoreNetworkConfigurationArgs.builder()
 *                 .asnRanges("65022-65534")
 *                 .edgeLocations(
 *                     GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocationArgs.builder()
 *                         .location("us-west-2")
 *                         .asn("65500")
 *                         .build(),
 *                     GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocationArgs.builder()
 *                         .location("us-east-1")
 *                         .asn("65501")
 *                         .build())
 *                 .build())
 *             .segments(GetCoreNetworkPolicyDocumentSegmentArgs.builder()
 *                 .name("segment")
 *                 .build())
 *             .build());
 *         var exampleCoreNetwork = new CoreNetwork("exampleCoreNetwork", CoreNetworkArgs.builder()
 *             .globalNetworkId(exampleGlobalNetwork.id())
 *             .basePolicyDocument(base.applyValue(getCoreNetworkPolicyDocumentResult -> getCoreNetworkPolicyDocumentResult.json()))
 *             .createBasePolicy(true)
 *             .build());
 *         var exampleUsWest2 = new VpcAttachment("exampleUsWest2", VpcAttachmentArgs.builder()
 *             .coreNetworkId(exampleCoreNetwork.id())
 *             .subnetArns(aws_subnet.example_us_west_2().stream().map(element -> element.arn()).collect(toList()))
 *             .vpcArn(aws_vpc.example_us_west_2().arn())
 *             .build());
 *         var exampleUsEast1 = new VpcAttachment("exampleUsEast1", VpcAttachmentArgs.builder()
 *             .coreNetworkId(exampleCoreNetwork.id())
 *             .subnetArns(aws_subnet.example_us_east_1().stream().map(element -> element.arn()).collect(toList()))
 *             .vpcArn(aws_vpc.example_us_east_1().arn())
 *             .build(), CustomResourceOptions.builder()
 *                 .provider("alternate")
 *                 .build());
 *         final var exampleCoreNetworkPolicyDocument = NetworkmanagerFunctions.getCoreNetworkPolicyDocument(GetCoreNetworkPolicyDocumentArgs.builder()
 *             .coreNetworkConfigurations(GetCoreNetworkPolicyDocumentCoreNetworkConfigurationArgs.builder()
 *                 .asnRanges("65022-65534")
 *                 .edgeLocations(
 *                     GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocationArgs.builder()
 *                         .location("us-west-2")
 *                         .asn("65500")
 *                         .build(),
 *                     GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocationArgs.builder()
 *                         .location("us-east-1")
 *                         .asn("65501")
 *                         .build())
 *                 .build())
 *             .segments(
 *                 GetCoreNetworkPolicyDocumentSegmentArgs.builder()
 *                     .name("segment")
 *                     .build(),
 *                 GetCoreNetworkPolicyDocumentSegmentArgs.builder()
 *                     .name("segment2")
 *                     .build())
 *             .segmentActions(
 *                 GetCoreNetworkPolicyDocumentSegmentActionArgs.builder()
 *                     .action("create-route")
 *                     .segment("segment")
 *                     .destinationCidrBlocks("10.0.0.0/16")
 *                     .destinations(exampleUsWest2.id())
 *                     .build(),
 *                 GetCoreNetworkPolicyDocumentSegmentActionArgs.builder()
 *                     .action("create-route")
 *                     .segment("segment")
 *                     .destinationCidrBlocks("10.1.0.0/16")
 *                     .destinations(exampleUsEast1.id())
 *                     .build())
 *             .build());
 *         var exampleCoreNetworkPolicyAttachment = new CoreNetworkPolicyAttachment("exampleCoreNetworkPolicyAttachment", CoreNetworkPolicyAttachmentArgs.builder()
 *             .coreNetworkId(exampleCoreNetwork.id())
 *             .policyDocument(exampleCoreNetworkPolicyDocument.applyValue(getCoreNetworkPolicyDocumentResult -> getCoreNetworkPolicyDocumentResult).applyValue(exampleCoreNetworkPolicyDocument -> exampleCoreNetworkPolicyDocument.applyValue(getCoreNetworkPolicyDocumentResult -> getCoreNetworkPolicyDocumentResult.json())))
 *             .build());
 *     }
 * }
 * ```
 * ### Option 2 - using base_policy_regions
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkmanager.GlobalNetwork;
 * import com.pulumi.aws.networkmanager.CoreNetwork;
 * import com.pulumi.aws.networkmanager.CoreNetworkArgs;
 * import com.pulumi.aws.networkmanager.VpcAttachment;
 * import com.pulumi.aws.networkmanager.VpcAttachmentArgs;
 * import com.pulumi.aws.networkmanager.NetworkmanagerFunctions;
 * import com.pulumi.aws.networkmanager.inputs.GetCoreNetworkPolicyDocumentArgs;
 * import com.pulumi.aws.networkmanager.CoreNetworkPolicyAttachment;
 * import com.pulumi.aws.networkmanager.CoreNetworkPolicyAttachmentArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleGlobalNetwork = new GlobalNetwork("exampleGlobalNetwork");
 *         var exampleCoreNetwork = new CoreNetwork("exampleCoreNetwork", CoreNetworkArgs.builder()
 *             .globalNetworkId(exampleGlobalNetwork.id())
 *             .basePolicyRegions(
 *                 "us-west-2",
 *                 "us-east-1")
 *             .createBasePolicy(true)
 *             .build());
 *         var exampleUsWest2 = new VpcAttachment("exampleUsWest2", VpcAttachmentArgs.builder()
 *             .coreNetworkId(exampleCoreNetwork.id())
 *             .subnetArns(aws_subnet.example_us_west_2().stream().map(element -> element.arn()).collect(toList()))
 *             .vpcArn(aws_vpc.example_us_west_2().arn())
 *             .build());
 *         var exampleUsEast1 = new VpcAttachment("exampleUsEast1", VpcAttachmentArgs.builder()
 *             .coreNetworkId(exampleCoreNetwork.id())
 *             .subnetArns(aws_subnet.example_us_east_1().stream().map(element -> element.arn()).collect(toList()))
 *             .vpcArn(aws_vpc.example_us_east_1().arn())
 *             .build(), CustomResourceOptions.builder()
 *                 .provider("alternate")
 *                 .build());
 *         final var exampleCoreNetworkPolicyDocument = NetworkmanagerFunctions.getCoreNetworkPolicyDocument(GetCoreNetworkPolicyDocumentArgs.builder()
 *             .coreNetworkConfigurations(GetCoreNetworkPolicyDocumentCoreNetworkConfigurationArgs.builder()
 *                 .asnRanges("65022-65534")
 *                 .edgeLocations(
 *                     GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocationArgs.builder()
 *                         .location("us-west-2")
 *                         .build(),
 *                     GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocationArgs.builder()
 *                         .location("us-east-1")
 *                         .build())
 *                 .build())
 *             .segments(
 *                 GetCoreNetworkPolicyDocumentSegmentArgs.builder()
 *                     .name("segment")
 *                     .build(),
 *                 GetCoreNetworkPolicyDocumentSegmentArgs.builder()
 *                     .name("segment2")
 *                     .build())
 *             .segmentActions(
 *                 GetCoreNetworkPolicyDocumentSegmentActionArgs.builder()
 *                     .action("create-route")
 *                     .segment("segment")
 *                     .destinationCidrBlocks("10.0.0.0/16")
 *                     .destinations(exampleUsWest2.id())
 *                     .build(),
 *                 GetCoreNetworkPolicyDocumentSegmentActionArgs.builder()
 *                     .action("create-route")
 *                     .segment("segment")
 *                     .destinationCidrBlocks("10.1.0.0/16")
 *                     .destinations(exampleUsEast1.id())
 *                     .build())
 *             .build());
 *         var exampleCoreNetworkPolicyAttachment = new CoreNetworkPolicyAttachment("exampleCoreNetworkPolicyAttachment", CoreNetworkPolicyAttachmentArgs.builder()
 *             .coreNetworkId(exampleCoreNetwork.id())
 *             .policyDocument(exampleCoreNetworkPolicyDocument.applyValue(getCoreNetworkPolicyDocumentResult -> getCoreNetworkPolicyDocumentResult).applyValue(exampleCoreNetworkPolicyDocument -> exampleCoreNetworkPolicyDocument.applyValue(getCoreNetworkPolicyDocumentResult -> getCoreNetworkPolicyDocumentResult.json())))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_networkmanager_core_network` using the core network ID. For example:
 * ```sh
 *  $ pulumi import aws:networkmanager/coreNetwork:CoreNetwork example core-network-0d47f6t230mz46dy4
 * ```
 *
 */
public class CoreNetwork internal constructor(
    override val javaResource: com.pulumi.aws.networkmanager.CoreNetwork,
) : KotlinCustomResource(javaResource, CoreNetworkMapper) {
    /**
     * Core Network Amazon Resource Name (ARN).
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Sets the base policy document for the core network. Refer to the [Core network policies documentation](https://docs.aws.amazon.com/network-manager/latest/cloudwan/cloudwan-policy-change-sets.html) for more information.
     */
    public val basePolicyDocument: Output<String>?
        get() = javaResource.basePolicyDocument().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The base policy created by setting the `create_base_policy` argument to `true` requires a region to be set in the `edge-locations`, `location` key. If `base_policy_region` is not specified, the region used in the base policy defaults to the region specified in the `provider` block.
     */
    @Deprecated(
        message = """
  Use the base_policy_regions argument instead. This argument will be removed in the next major
      version of the provider.
  """,
    )
    public val basePolicyRegion: Output<String>?
        get() = javaResource.basePolicyRegion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A list of regions to add to the base policy. The base policy created by setting the `create_base_policy` argument to `true` requires one or more regions to be set in the `edge-locations`, `location` key. If `base_policy_regions` is not specified, the region used in the base policy defaults to the region specified in the `provider` block.
     */
    public val basePolicyRegions: Output<List<String>>?
        get() = javaResource.basePolicyRegions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Specifies whether to create a base policy when a core network is created or updated. A base policy is created and set to `LIVE` to allow attachments to the core network (e.g. VPC Attachments) before applying a policy document provided using the `aws.networkmanager.CoreNetworkPolicyAttachment` resource. This base policy is needed if your core network does not have any `LIVE` policies and your policy document has static routes pointing to VPC attachments and you want to attach your VPCs to the core network before applying the desired policy document. Valid values are `true` or `false`. An example of this Pulumi snippet can be found above for VPC Attachment in a single region and for VPC Attachment multi-region. An example base policy is shown below. This base policy is overridden with the policy that you specify in the `aws.networkmanager.CoreNetworkPolicyAttachment` resource.
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * ```
     * ```python
     * import pulumi
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * return await Deployment.RunAsync(() =>
     * {
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *     }
     * }
     * ```
     * ```yaml
     * {}
     * ```
     */
    public val createBasePolicy: Output<Boolean>?
        get() = javaResource.createBasePolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Timestamp when a core network was created.
     */
    public val createdAt: Output<String>
        get() = javaResource.createdAt().applyValue({ args0 -> args0 })

    /**
     * Description of the Core Network.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * One or more blocks detailing the edges within a core network. Detailed below.
     */
    public val edges: Output<List<CoreNetworkEdge>>
        get() = javaResource.edges().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    coreNetworkEdgeToKotlin(args0)
                })
            })
        })

    /**
     * The ID of the global network that a core network will be a part of.
     */
    public val globalNetworkId: Output<String>
        get() = javaResource.globalNetworkId().applyValue({ args0 -> args0 })

    /**
     * One or more blocks detailing the segments within a core network. Detailed below.
     */
    public val segments: Output<List<CoreNetworkSegment>>
        get() = javaResource.segments().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    coreNetworkSegmentToKotlin(args0)
                })
            })
        })

    /**
     * Current state of a core network.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * Key-value tags for the Core Network. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object CoreNetworkMapper : ResourceMapper<CoreNetwork> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.networkmanager.CoreNetwork::class == javaResource::class

    override fun map(javaResource: Resource): CoreNetwork = CoreNetwork(
        javaResource as
            com.pulumi.aws.networkmanager.CoreNetwork,
    )
}

/**
 * @see [CoreNetwork].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CoreNetwork].
 */
public suspend fun coreNetwork(name: String, block: suspend CoreNetworkResourceBuilder.() -> Unit):
    CoreNetwork {
    val builder = CoreNetworkResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CoreNetwork].
 * @param name The _unique_ name of the resulting resource.
 */
public fun coreNetwork(name: String): CoreNetwork {
    val builder = CoreNetworkResourceBuilder()
    builder.name(name)
    return builder.build()
}
