@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [CoreNetworkPolicyAttachment].
 */
@PulumiTagMarker
public class CoreNetworkPolicyAttachmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CoreNetworkPolicyAttachmentArgs = CoreNetworkPolicyAttachmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CoreNetworkPolicyAttachmentArgsBuilder.() -> Unit) {
        val builder = CoreNetworkPolicyAttachmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): CoreNetworkPolicyAttachment {
        val builtJavaResource =
            com.pulumi.aws.networkmanager.CoreNetworkPolicyAttachment(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return CoreNetworkPolicyAttachment(builtJavaResource)
    }
}

/**
 * Provides a Core Network Policy Attachment resource. This puts a Core Network Policy to an existing Core Network and executes the change set, which deploys changes globally based on the policy submitted (Sets the policy to `LIVE`).
 * > **NOTE:** Deleting this resource will not delete the current policy defined in this resource. Deleting this resource will also not revert the current `LIVE` policy to the previous version.
 * ## Example Usage
 * ### Basic
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkmanager.CoreNetwork;
 * import com.pulumi.aws.networkmanager.CoreNetworkArgs;
 * import com.pulumi.aws.networkmanager.CoreNetworkPolicyAttachment;
 * import com.pulumi.aws.networkmanager.CoreNetworkPolicyAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleCoreNetwork = new CoreNetwork("exampleCoreNetwork", CoreNetworkArgs.builder()
 *             .globalNetworkId(aws_networkmanager_global_network.example().id())
 *             .build());
 *         var exampleCoreNetworkPolicyAttachment = new CoreNetworkPolicyAttachment("exampleCoreNetworkPolicyAttachment", CoreNetworkPolicyAttachmentArgs.builder()
 *             .coreNetworkId(exampleCoreNetwork.id())
 *             .policyDocument(data.aws_networkmanager_core_network_policy_document().example().json())
 *             .build());
 *     }
 * }
 * ```
 * ### Option 1 - using base_policy_document
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkmanager.GlobalNetwork;
 * import com.pulumi.aws.networkmanager.NetworkmanagerFunctions;
 * import com.pulumi.aws.networkmanager.inputs.GetCoreNetworkPolicyDocumentArgs;
 * import com.pulumi.aws.networkmanager.CoreNetwork;
 * import com.pulumi.aws.networkmanager.CoreNetworkArgs;
 * import com.pulumi.aws.networkmanager.VpcAttachment;
 * import com.pulumi.aws.networkmanager.VpcAttachmentArgs;
 * import com.pulumi.aws.networkmanager.CoreNetworkPolicyAttachment;
 * import com.pulumi.aws.networkmanager.CoreNetworkPolicyAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleGlobalNetwork = new GlobalNetwork("exampleGlobalNetwork");
 *         final var base = NetworkmanagerFunctions.getCoreNetworkPolicyDocument(GetCoreNetworkPolicyDocumentArgs.builder()
 *             .coreNetworkConfigurations(GetCoreNetworkPolicyDocumentCoreNetworkConfigurationArgs.builder()
 *                 .asnRanges("65022-65534")
 *                 .edgeLocations(GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocationArgs.builder()
 *                     .location("us-west-2")
 *                     .asn("65500")
 *                     .build())
 *                 .build())
 *             .segments(GetCoreNetworkPolicyDocumentSegmentArgs.builder()
 *                 .name("segment")
 *                 .build())
 *             .build());
 *         var exampleCoreNetwork = new CoreNetwork("exampleCoreNetwork", CoreNetworkArgs.builder()
 *             .globalNetworkId(exampleGlobalNetwork.id())
 *             .basePolicyDocument(base.applyValue(getCoreNetworkPolicyDocumentResult -> getCoreNetworkPolicyDocumentResult.json()))
 *             .createBasePolicy(true)
 *             .build());
 *         var exampleVpcAttachment = new VpcAttachment("exampleVpcAttachment", VpcAttachmentArgs.builder()
 *             .coreNetworkId(exampleCoreNetwork.id())
 *             .subnetArns(aws_subnet.example().stream().map(element -> element.arn()).collect(toList()))
 *             .vpcArn(aws_vpc.example().arn())
 *             .build());
 *         final var exampleCoreNetworkPolicyDocument = NetworkmanagerFunctions.getCoreNetworkPolicyDocument(GetCoreNetworkPolicyDocumentArgs.builder()
 *             .coreNetworkConfigurations(GetCoreNetworkPolicyDocumentCoreNetworkConfigurationArgs.builder()
 *                 .asnRanges("65022-65534")
 *                 .edgeLocations(GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocationArgs.builder()
 *                     .location("us-west-2")
 *                     .asn("65500")
 *                     .build())
 *                 .build())
 *             .segments(GetCoreNetworkPolicyDocumentSegmentArgs.builder()
 *                 .name("segment")
 *                 .build())
 *             .segmentActions(GetCoreNetworkPolicyDocumentSegmentActionArgs.builder()
 *                 .action("create-route")
 *                 .segment("segment")
 *                 .destinationCidrBlocks("0.0.0.0/0")
 *                 .destinations(exampleVpcAttachment.id())
 *                 .build())
 *             .build());
 *         var exampleCoreNetworkPolicyAttachment = new CoreNetworkPolicyAttachment("exampleCoreNetworkPolicyAttachment", CoreNetworkPolicyAttachmentArgs.builder()
 *             .coreNetworkId(exampleCoreNetwork.id())
 *             .policyDocument(exampleCoreNetworkPolicyDocument.applyValue(getCoreNetworkPolicyDocumentResult -> getCoreNetworkPolicyDocumentResult).applyValue(exampleCoreNetworkPolicyDocument -> exampleCoreNetworkPolicyDocument.applyValue(getCoreNetworkPolicyDocumentResult -> getCoreNetworkPolicyDocumentResult.json())))
 *             .build());
 *     }
 * }
 * ```
 * ### Option 2 - create_base_policy only
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkmanager.GlobalNetwork;
 * import com.pulumi.aws.networkmanager.CoreNetwork;
 * import com.pulumi.aws.networkmanager.CoreNetworkArgs;
 * import com.pulumi.aws.networkmanager.VpcAttachment;
 * import com.pulumi.aws.networkmanager.VpcAttachmentArgs;
 * import com.pulumi.aws.networkmanager.NetworkmanagerFunctions;
 * import com.pulumi.aws.networkmanager.inputs.GetCoreNetworkPolicyDocumentArgs;
 * import com.pulumi.aws.networkmanager.CoreNetworkPolicyAttachment;
 * import com.pulumi.aws.networkmanager.CoreNetworkPolicyAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleGlobalNetwork = new GlobalNetwork("exampleGlobalNetwork");
 *         var exampleCoreNetwork = new CoreNetwork("exampleCoreNetwork", CoreNetworkArgs.builder()
 *             .globalNetworkId(exampleGlobalNetwork.id())
 *             .createBasePolicy(true)
 *             .build());
 *         var exampleVpcAttachment = new VpcAttachment("exampleVpcAttachment", VpcAttachmentArgs.builder()
 *             .coreNetworkId(exampleCoreNetwork.id())
 *             .subnetArns(aws_subnet.example().stream().map(element -> element.arn()).collect(toList()))
 *             .vpcArn(aws_vpc.example().arn())
 *             .build());
 *         final var exampleCoreNetworkPolicyDocument = NetworkmanagerFunctions.getCoreNetworkPolicyDocument(GetCoreNetworkPolicyDocumentArgs.builder()
 *             .coreNetworkConfigurations(GetCoreNetworkPolicyDocumentCoreNetworkConfigurationArgs.builder()
 *                 .asnRanges("65022-65534")
 *                 .edgeLocations(GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocationArgs.builder()
 *                     .location("us-west-2")
 *                     .build())
 *                 .build())
 *             .segments(GetCoreNetworkPolicyDocumentSegmentArgs.builder()
 *                 .name("segment")
 *                 .build())
 *             .segmentActions(GetCoreNetworkPolicyDocumentSegmentActionArgs.builder()
 *                 .action("create-route")
 *                 .segment("segment")
 *                 .destinationCidrBlocks("0.0.0.0/0")
 *                 .destinations(exampleVpcAttachment.id())
 *                 .build())
 *             .build());
 *         var exampleCoreNetworkPolicyAttachment = new CoreNetworkPolicyAttachment("exampleCoreNetworkPolicyAttachment", CoreNetworkPolicyAttachmentArgs.builder()
 *             .coreNetworkId(exampleCoreNetwork.id())
 *             .policyDocument(exampleCoreNetworkPolicyDocument.applyValue(getCoreNetworkPolicyDocumentResult -> getCoreNetworkPolicyDocumentResult).applyValue(exampleCoreNetworkPolicyDocument -> exampleCoreNetworkPolicyDocument.applyValue(getCoreNetworkPolicyDocumentResult -> getCoreNetworkPolicyDocumentResult.json())))
 *             .build());
 *     }
 * }
 * ```
 * ### Option 1 - using base_policy_document
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkmanager.GlobalNetwork;
 * import com.pulumi.aws.networkmanager.NetworkmanagerFunctions;
 * import com.pulumi.aws.networkmanager.inputs.GetCoreNetworkPolicyDocumentArgs;
 * import com.pulumi.aws.networkmanager.CoreNetwork;
 * import com.pulumi.aws.networkmanager.CoreNetworkArgs;
 * import com.pulumi.aws.networkmanager.VpcAttachment;
 * import com.pulumi.aws.networkmanager.VpcAttachmentArgs;
 * import com.pulumi.aws.networkmanager.CoreNetworkPolicyAttachment;
 * import com.pulumi.aws.networkmanager.CoreNetworkPolicyAttachmentArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleGlobalNetwork = new GlobalNetwork("exampleGlobalNetwork");
 *         final var base = NetworkmanagerFunctions.getCoreNetworkPolicyDocument(GetCoreNetworkPolicyDocumentArgs.builder()
 *             .coreNetworkConfigurations(GetCoreNetworkPolicyDocumentCoreNetworkConfigurationArgs.builder()
 *                 .asnRanges("65022-65534")
 *                 .edgeLocations(
 *                     GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocationArgs.builder()
 *                         .location("us-west-2")
 *                         .asn("65500")
 *                         .build(),
 *                     GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocationArgs.builder()
 *                         .location("us-east-1")
 *                         .asn("65501")
 *                         .build())
 *                 .build())
 *             .segments(GetCoreNetworkPolicyDocumentSegmentArgs.builder()
 *                 .name("segment")
 *                 .build())
 *             .build());
 *         var exampleCoreNetwork = new CoreNetwork("exampleCoreNetwork", CoreNetworkArgs.builder()
 *             .globalNetworkId(exampleGlobalNetwork.id())
 *             .basePolicyDocument(base.applyValue(getCoreNetworkPolicyDocumentResult -> getCoreNetworkPolicyDocumentResult.json()))
 *             .createBasePolicy(true)
 *             .build());
 *         var exampleUsWest2 = new VpcAttachment("exampleUsWest2", VpcAttachmentArgs.builder()
 *             .coreNetworkId(exampleCoreNetwork.id())
 *             .subnetArns(aws_subnet.example_us_west_2().stream().map(element -> element.arn()).collect(toList()))
 *             .vpcArn(aws_vpc.example_us_west_2().arn())
 *             .build());
 *         var exampleUsEast1 = new VpcAttachment("exampleUsEast1", VpcAttachmentArgs.builder()
 *             .coreNetworkId(exampleCoreNetwork.id())
 *             .subnetArns(aws_subnet.example_us_east_1().stream().map(element -> element.arn()).collect(toList()))
 *             .vpcArn(aws_vpc.example_us_east_1().arn())
 *             .build(), CustomResourceOptions.builder()
 *                 .provider("alternate")
 *                 .build());
 *         final var exampleCoreNetworkPolicyDocument = NetworkmanagerFunctions.getCoreNetworkPolicyDocument(GetCoreNetworkPolicyDocumentArgs.builder()
 *             .coreNetworkConfigurations(GetCoreNetworkPolicyDocumentCoreNetworkConfigurationArgs.builder()
 *                 .asnRanges("65022-65534")
 *                 .edgeLocations(
 *                     GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocationArgs.builder()
 *                         .location("us-west-2")
 *                         .asn("65500")
 *                         .build(),
 *                     GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocationArgs.builder()
 *                         .location("us-east-1")
 *                         .asn("65501")
 *                         .build())
 *                 .build())
 *             .segments(
 *                 GetCoreNetworkPolicyDocumentSegmentArgs.builder()
 *                     .name("segment")
 *                     .build(),
 *                 GetCoreNetworkPolicyDocumentSegmentArgs.builder()
 *                     .name("segment2")
 *                     .build())
 *             .segmentActions(
 *                 GetCoreNetworkPolicyDocumentSegmentActionArgs.builder()
 *                     .action("create-route")
 *                     .segment("segment")
 *                     .destinationCidrBlocks("10.0.0.0/16")
 *                     .destinations(exampleUsWest2.id())
 *                     .build(),
 *                 GetCoreNetworkPolicyDocumentSegmentActionArgs.builder()
 *                     .action("create-route")
 *                     .segment("segment")
 *                     .destinationCidrBlocks("10.1.0.0/16")
 *                     .destinations(exampleUsEast1.id())
 *                     .build())
 *             .build());
 *         var exampleCoreNetworkPolicyAttachment = new CoreNetworkPolicyAttachment("exampleCoreNetworkPolicyAttachment", CoreNetworkPolicyAttachmentArgs.builder()
 *             .coreNetworkId(exampleCoreNetwork.id())
 *             .policyDocument(exampleCoreNetworkPolicyDocument.applyValue(getCoreNetworkPolicyDocumentResult -> getCoreNetworkPolicyDocumentResult).applyValue(exampleCoreNetworkPolicyDocument -> exampleCoreNetworkPolicyDocument.applyValue(getCoreNetworkPolicyDocumentResult -> getCoreNetworkPolicyDocumentResult.json())))
 *             .build());
 *     }
 * }
 * ```
 * ### Option 2 - using base_policy_regions
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkmanager.GlobalNetwork;
 * import com.pulumi.aws.networkmanager.CoreNetwork;
 * import com.pulumi.aws.networkmanager.CoreNetworkArgs;
 * import com.pulumi.aws.networkmanager.VpcAttachment;
 * import com.pulumi.aws.networkmanager.VpcAttachmentArgs;
 * import com.pulumi.aws.networkmanager.NetworkmanagerFunctions;
 * import com.pulumi.aws.networkmanager.inputs.GetCoreNetworkPolicyDocumentArgs;
 * import com.pulumi.aws.networkmanager.CoreNetworkPolicyAttachment;
 * import com.pulumi.aws.networkmanager.CoreNetworkPolicyAttachmentArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleGlobalNetwork = new GlobalNetwork("exampleGlobalNetwork");
 *         var exampleCoreNetwork = new CoreNetwork("exampleCoreNetwork", CoreNetworkArgs.builder()
 *             .globalNetworkId(exampleGlobalNetwork.id())
 *             .basePolicyRegions(
 *                 "us-west-2",
 *                 "us-east-1")
 *             .createBasePolicy(true)
 *             .build());
 *         var exampleUsWest2 = new VpcAttachment("exampleUsWest2", VpcAttachmentArgs.builder()
 *             .coreNetworkId(exampleCoreNetwork.id())
 *             .subnetArns(aws_subnet.example_us_west_2().stream().map(element -> element.arn()).collect(toList()))
 *             .vpcArn(aws_vpc.example_us_west_2().arn())
 *             .build());
 *         var exampleUsEast1 = new VpcAttachment("exampleUsEast1", VpcAttachmentArgs.builder()
 *             .coreNetworkId(exampleCoreNetwork.id())
 *             .subnetArns(aws_subnet.example_us_east_1().stream().map(element -> element.arn()).collect(toList()))
 *             .vpcArn(aws_vpc.example_us_east_1().arn())
 *             .build(), CustomResourceOptions.builder()
 *                 .provider("alternate")
 *                 .build());
 *         final var exampleCoreNetworkPolicyDocument = NetworkmanagerFunctions.getCoreNetworkPolicyDocument(GetCoreNetworkPolicyDocumentArgs.builder()
 *             .coreNetworkConfigurations(GetCoreNetworkPolicyDocumentCoreNetworkConfigurationArgs.builder()
 *                 .asnRanges("65022-65534")
 *                 .edgeLocations(
 *                     GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocationArgs.builder()
 *                         .location("us-west-2")
 *                         .build(),
 *                     GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocationArgs.builder()
 *                         .location("us-east-1")
 *                         .build())
 *                 .build())
 *             .segments(
 *                 GetCoreNetworkPolicyDocumentSegmentArgs.builder()
 *                     .name("segment")
 *                     .build(),
 *                 GetCoreNetworkPolicyDocumentSegmentArgs.builder()
 *                     .name("segment2")
 *                     .build())
 *             .segmentActions(
 *                 GetCoreNetworkPolicyDocumentSegmentActionArgs.builder()
 *                     .action("create-route")
 *                     .segment("segment")
 *                     .destinationCidrBlocks("10.0.0.0/16")
 *                     .destinations(exampleUsWest2.id())
 *                     .build(),
 *                 GetCoreNetworkPolicyDocumentSegmentActionArgs.builder()
 *                     .action("create-route")
 *                     .segment("segment")
 *                     .destinationCidrBlocks("10.1.0.0/16")
 *                     .destinations(exampleUsEast1.id())
 *                     .build())
 *             .build());
 *         var exampleCoreNetworkPolicyAttachment = new CoreNetworkPolicyAttachment("exampleCoreNetworkPolicyAttachment", CoreNetworkPolicyAttachmentArgs.builder()
 *             .coreNetworkId(exampleCoreNetwork.id())
 *             .policyDocument(exampleCoreNetworkPolicyDocument.applyValue(getCoreNetworkPolicyDocumentResult -> getCoreNetworkPolicyDocumentResult).applyValue(exampleCoreNetworkPolicyDocument -> exampleCoreNetworkPolicyDocument.applyValue(getCoreNetworkPolicyDocumentResult -> getCoreNetworkPolicyDocumentResult.json())))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_networkmanager_core_network_policy_attachment` using the core network ID. For example:
 * ```sh
 *  $ pulumi import aws:networkmanager/coreNetworkPolicyAttachment:CoreNetworkPolicyAttachment example core-network-0d47f6t230mz46dy4
 * ```
 *
 */
public class CoreNetworkPolicyAttachment internal constructor(
    override val javaResource: com.pulumi.aws.networkmanager.CoreNetworkPolicyAttachment,
) : KotlinCustomResource(javaResource, CoreNetworkPolicyAttachmentMapper) {
    /**
     * The ID of the core network that a policy will be attached to and made `LIVE`.
     */
    public val coreNetworkId: Output<String>
        get() = javaResource.coreNetworkId().applyValue({ args0 -> args0 })

    /**
     * Policy document for creating a core network. Note that updating this argument will result in the new policy document version being set as the `LATEST` and `LIVE` policy document. Refer to the [Core network policies documentation](https://docs.aws.amazon.com/network-manager/latest/cloudwan/cloudwan-policy-change-sets.html) for more information.
     */
    public val policyDocument: Output<String>
        get() = javaResource.policyDocument().applyValue({ args0 -> args0 })

    /**
     * Current state of a core network.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })
}

public object CoreNetworkPolicyAttachmentMapper : ResourceMapper<CoreNetworkPolicyAttachment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.networkmanager.CoreNetworkPolicyAttachment::class == javaResource::class

    override fun map(javaResource: Resource): CoreNetworkPolicyAttachment =
        CoreNetworkPolicyAttachment(
            javaResource as
                com.pulumi.aws.networkmanager.CoreNetworkPolicyAttachment,
        )
}

/**
 * @see [CoreNetworkPolicyAttachment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CoreNetworkPolicyAttachment].
 */
public suspend fun coreNetworkPolicyAttachment(
    name: String,
    block: suspend CoreNetworkPolicyAttachmentResourceBuilder.() -> Unit,
):
    CoreNetworkPolicyAttachment {
    val builder = CoreNetworkPolicyAttachmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CoreNetworkPolicyAttachment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun coreNetworkPolicyAttachment(name: String): CoreNetworkPolicyAttachment {
    val builder = CoreNetworkPolicyAttachmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
