@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin

import com.pulumi.aws.networkmanager.CoreNetworkPolicyAttachmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Core Network Policy Attachment resource. This puts a Core Network Policy to an existing Core Network and executes the change set, which deploys changes globally based on the policy submitted (Sets the policy to `LIVE`).
 * > **NOTE:** Deleting this resource will not delete the current policy defined in this resource. Deleting this resource will also not revert the current `LIVE` policy to the previous version.
 * ## Example Usage
 * ### Basic
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkmanager.CoreNetwork;
 * import com.pulumi.aws.networkmanager.CoreNetworkArgs;
 * import com.pulumi.aws.networkmanager.CoreNetworkPolicyAttachment;
 * import com.pulumi.aws.networkmanager.CoreNetworkPolicyAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleCoreNetwork = new CoreNetwork("exampleCoreNetwork", CoreNetworkArgs.builder()
 *             .globalNetworkId(aws_networkmanager_global_network.example().id())
 *             .build());
 *         var exampleCoreNetworkPolicyAttachment = new CoreNetworkPolicyAttachment("exampleCoreNetworkPolicyAttachment", CoreNetworkPolicyAttachmentArgs.builder()
 *             .coreNetworkId(exampleCoreNetwork.id())
 *             .policyDocument(data.aws_networkmanager_core_network_policy_document().example().json())
 *             .build());
 *     }
 * }
 * ```
 * ### Option 1 - using base_policy_document
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkmanager.GlobalNetwork;
 * import com.pulumi.aws.networkmanager.NetworkmanagerFunctions;
 * import com.pulumi.aws.networkmanager.inputs.GetCoreNetworkPolicyDocumentArgs;
 * import com.pulumi.aws.networkmanager.CoreNetwork;
 * import com.pulumi.aws.networkmanager.CoreNetworkArgs;
 * import com.pulumi.aws.networkmanager.VpcAttachment;
 * import com.pulumi.aws.networkmanager.VpcAttachmentArgs;
 * import com.pulumi.aws.networkmanager.CoreNetworkPolicyAttachment;
 * import com.pulumi.aws.networkmanager.CoreNetworkPolicyAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleGlobalNetwork = new GlobalNetwork("exampleGlobalNetwork");
 *         final var base = NetworkmanagerFunctions.getCoreNetworkPolicyDocument(GetCoreNetworkPolicyDocumentArgs.builder()
 *             .coreNetworkConfigurations(GetCoreNetworkPolicyDocumentCoreNetworkConfigurationArgs.builder()
 *                 .asnRanges("65022-65534")
 *                 .edgeLocations(GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocationArgs.builder()
 *                     .location("us-west-2")
 *                     .asn("65500")
 *                     .build())
 *                 .build())
 *             .segments(GetCoreNetworkPolicyDocumentSegmentArgs.builder()
 *                 .name("segment")
 *                 .build())
 *             .build());
 *         var exampleCoreNetwork = new CoreNetwork("exampleCoreNetwork", CoreNetworkArgs.builder()
 *             .globalNetworkId(exampleGlobalNetwork.id())
 *             .basePolicyDocument(base.applyValue(getCoreNetworkPolicyDocumentResult -> getCoreNetworkPolicyDocumentResult.json()))
 *             .createBasePolicy(true)
 *             .build());
 *         var exampleVpcAttachment = new VpcAttachment("exampleVpcAttachment", VpcAttachmentArgs.builder()
 *             .coreNetworkId(exampleCoreNetwork.id())
 *             .subnetArns(aws_subnet.example().stream().map(element -> element.arn()).collect(toList()))
 *             .vpcArn(aws_vpc.example().arn())
 *             .build());
 *         final var exampleCoreNetworkPolicyDocument = NetworkmanagerFunctions.getCoreNetworkPolicyDocument(GetCoreNetworkPolicyDocumentArgs.builder()
 *             .coreNetworkConfigurations(GetCoreNetworkPolicyDocumentCoreNetworkConfigurationArgs.builder()
 *                 .asnRanges("65022-65534")
 *                 .edgeLocations(GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocationArgs.builder()
 *                     .location("us-west-2")
 *                     .asn("65500")
 *                     .build())
 *                 .build())
 *             .segments(GetCoreNetworkPolicyDocumentSegmentArgs.builder()
 *                 .name("segment")
 *                 .build())
 *             .segmentActions(GetCoreNetworkPolicyDocumentSegmentActionArgs.builder()
 *                 .action("create-route")
 *                 .segment("segment")
 *                 .destinationCidrBlocks("0.0.0.0/0")
 *                 .destinations(exampleVpcAttachment.id())
 *                 .build())
 *             .build());
 *         var exampleCoreNetworkPolicyAttachment = new CoreNetworkPolicyAttachment("exampleCoreNetworkPolicyAttachment", CoreNetworkPolicyAttachmentArgs.builder()
 *             .coreNetworkId(exampleCoreNetwork.id())
 *             .policyDocument(exampleCoreNetworkPolicyDocument.applyValue(getCoreNetworkPolicyDocumentResult -> getCoreNetworkPolicyDocumentResult).applyValue(exampleCoreNetworkPolicyDocument -> exampleCoreNetworkPolicyDocument.applyValue(getCoreNetworkPolicyDocumentResult -> getCoreNetworkPolicyDocumentResult.json())))
 *             .build());
 *     }
 * }
 * ```
 * ### Option 2 - create_base_policy only
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkmanager.GlobalNetwork;
 * import com.pulumi.aws.networkmanager.CoreNetwork;
 * import com.pulumi.aws.networkmanager.CoreNetworkArgs;
 * import com.pulumi.aws.networkmanager.VpcAttachment;
 * import com.pulumi.aws.networkmanager.VpcAttachmentArgs;
 * import com.pulumi.aws.networkmanager.NetworkmanagerFunctions;
 * import com.pulumi.aws.networkmanager.inputs.GetCoreNetworkPolicyDocumentArgs;
 * import com.pulumi.aws.networkmanager.CoreNetworkPolicyAttachment;
 * import com.pulumi.aws.networkmanager.CoreNetworkPolicyAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleGlobalNetwork = new GlobalNetwork("exampleGlobalNetwork");
 *         var exampleCoreNetwork = new CoreNetwork("exampleCoreNetwork", CoreNetworkArgs.builder()
 *             .globalNetworkId(exampleGlobalNetwork.id())
 *             .createBasePolicy(true)
 *             .build());
 *         var exampleVpcAttachment = new VpcAttachment("exampleVpcAttachment", VpcAttachmentArgs.builder()
 *             .coreNetworkId(exampleCoreNetwork.id())
 *             .subnetArns(aws_subnet.example().stream().map(element -> element.arn()).collect(toList()))
 *             .vpcArn(aws_vpc.example().arn())
 *             .build());
 *         final var exampleCoreNetworkPolicyDocument = NetworkmanagerFunctions.getCoreNetworkPolicyDocument(GetCoreNetworkPolicyDocumentArgs.builder()
 *             .coreNetworkConfigurations(GetCoreNetworkPolicyDocumentCoreNetworkConfigurationArgs.builder()
 *                 .asnRanges("65022-65534")
 *                 .edgeLocations(GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocationArgs.builder()
 *                     .location("us-west-2")
 *                     .build())
 *                 .build())
 *             .segments(GetCoreNetworkPolicyDocumentSegmentArgs.builder()
 *                 .name("segment")
 *                 .build())
 *             .segmentActions(GetCoreNetworkPolicyDocumentSegmentActionArgs.builder()
 *                 .action("create-route")
 *                 .segment("segment")
 *                 .destinationCidrBlocks("0.0.0.0/0")
 *                 .destinations(exampleVpcAttachment.id())
 *                 .build())
 *             .build());
 *         var exampleCoreNetworkPolicyAttachment = new CoreNetworkPolicyAttachment("exampleCoreNetworkPolicyAttachment", CoreNetworkPolicyAttachmentArgs.builder()
 *             .coreNetworkId(exampleCoreNetwork.id())
 *             .policyDocument(exampleCoreNetworkPolicyDocument.applyValue(getCoreNetworkPolicyDocumentResult -> getCoreNetworkPolicyDocumentResult).applyValue(exampleCoreNetworkPolicyDocument -> exampleCoreNetworkPolicyDocument.applyValue(getCoreNetworkPolicyDocumentResult -> getCoreNetworkPolicyDocumentResult.json())))
 *             .build());
 *     }
 * }
 * ```
 * ### Option 1 - using base_policy_document
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkmanager.GlobalNetwork;
 * import com.pulumi.aws.networkmanager.NetworkmanagerFunctions;
 * import com.pulumi.aws.networkmanager.inputs.GetCoreNetworkPolicyDocumentArgs;
 * import com.pulumi.aws.networkmanager.CoreNetwork;
 * import com.pulumi.aws.networkmanager.CoreNetworkArgs;
 * import com.pulumi.aws.networkmanager.VpcAttachment;
 * import com.pulumi.aws.networkmanager.VpcAttachmentArgs;
 * import com.pulumi.aws.networkmanager.CoreNetworkPolicyAttachment;
 * import com.pulumi.aws.networkmanager.CoreNetworkPolicyAttachmentArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleGlobalNetwork = new GlobalNetwork("exampleGlobalNetwork");
 *         final var base = NetworkmanagerFunctions.getCoreNetworkPolicyDocument(GetCoreNetworkPolicyDocumentArgs.builder()
 *             .coreNetworkConfigurations(GetCoreNetworkPolicyDocumentCoreNetworkConfigurationArgs.builder()
 *                 .asnRanges("65022-65534")
 *                 .edgeLocations(
 *                     GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocationArgs.builder()
 *                         .location("us-west-2")
 *                         .asn("65500")
 *                         .build(),
 *                     GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocationArgs.builder()
 *                         .location("us-east-1")
 *                         .asn("65501")
 *                         .build())
 *                 .build())
 *             .segments(GetCoreNetworkPolicyDocumentSegmentArgs.builder()
 *                 .name("segment")
 *                 .build())
 *             .build());
 *         var exampleCoreNetwork = new CoreNetwork("exampleCoreNetwork", CoreNetworkArgs.builder()
 *             .globalNetworkId(exampleGlobalNetwork.id())
 *             .basePolicyDocument(base.applyValue(getCoreNetworkPolicyDocumentResult -> getCoreNetworkPolicyDocumentResult.json()))
 *             .createBasePolicy(true)
 *             .build());
 *         var exampleUsWest2 = new VpcAttachment("exampleUsWest2", VpcAttachmentArgs.builder()
 *             .coreNetworkId(exampleCoreNetwork.id())
 *             .subnetArns(aws_subnet.example_us_west_2().stream().map(element -> element.arn()).collect(toList()))
 *             .vpcArn(aws_vpc.example_us_west_2().arn())
 *             .build());
 *         var exampleUsEast1 = new VpcAttachment("exampleUsEast1", VpcAttachmentArgs.builder()
 *             .coreNetworkId(exampleCoreNetwork.id())
 *             .subnetArns(aws_subnet.example_us_east_1().stream().map(element -> element.arn()).collect(toList()))
 *             .vpcArn(aws_vpc.example_us_east_1().arn())
 *             .build(), CustomResourceOptions.builder()
 *                 .provider("alternate")
 *                 .build());
 *         final var exampleCoreNetworkPolicyDocument = NetworkmanagerFunctions.getCoreNetworkPolicyDocument(GetCoreNetworkPolicyDocumentArgs.builder()
 *             .coreNetworkConfigurations(GetCoreNetworkPolicyDocumentCoreNetworkConfigurationArgs.builder()
 *                 .asnRanges("65022-65534")
 *                 .edgeLocations(
 *                     GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocationArgs.builder()
 *                         .location("us-west-2")
 *                         .asn("65500")
 *                         .build(),
 *                     GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocationArgs.builder()
 *                         .location("us-east-1")
 *                         .asn("65501")
 *                         .build())
 *                 .build())
 *             .segments(
 *                 GetCoreNetworkPolicyDocumentSegmentArgs.builder()
 *                     .name("segment")
 *                     .build(),
 *                 GetCoreNetworkPolicyDocumentSegmentArgs.builder()
 *                     .name("segment2")
 *                     .build())
 *             .segmentActions(
 *                 GetCoreNetworkPolicyDocumentSegmentActionArgs.builder()
 *                     .action("create-route")
 *                     .segment("segment")
 *                     .destinationCidrBlocks("10.0.0.0/16")
 *                     .destinations(exampleUsWest2.id())
 *                     .build(),
 *                 GetCoreNetworkPolicyDocumentSegmentActionArgs.builder()
 *                     .action("create-route")
 *                     .segment("segment")
 *                     .destinationCidrBlocks("10.1.0.0/16")
 *                     .destinations(exampleUsEast1.id())
 *                     .build())
 *             .build());
 *         var exampleCoreNetworkPolicyAttachment = new CoreNetworkPolicyAttachment("exampleCoreNetworkPolicyAttachment", CoreNetworkPolicyAttachmentArgs.builder()
 *             .coreNetworkId(exampleCoreNetwork.id())
 *             .policyDocument(exampleCoreNetworkPolicyDocument.applyValue(getCoreNetworkPolicyDocumentResult -> getCoreNetworkPolicyDocumentResult).applyValue(exampleCoreNetworkPolicyDocument -> exampleCoreNetworkPolicyDocument.applyValue(getCoreNetworkPolicyDocumentResult -> getCoreNetworkPolicyDocumentResult.json())))
 *             .build());
 *     }
 * }
 * ```
 * ### Option 2 - using base_policy_regions
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkmanager.GlobalNetwork;
 * import com.pulumi.aws.networkmanager.CoreNetwork;
 * import com.pulumi.aws.networkmanager.CoreNetworkArgs;
 * import com.pulumi.aws.networkmanager.VpcAttachment;
 * import com.pulumi.aws.networkmanager.VpcAttachmentArgs;
 * import com.pulumi.aws.networkmanager.NetworkmanagerFunctions;
 * import com.pulumi.aws.networkmanager.inputs.GetCoreNetworkPolicyDocumentArgs;
 * import com.pulumi.aws.networkmanager.CoreNetworkPolicyAttachment;
 * import com.pulumi.aws.networkmanager.CoreNetworkPolicyAttachmentArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleGlobalNetwork = new GlobalNetwork("exampleGlobalNetwork");
 *         var exampleCoreNetwork = new CoreNetwork("exampleCoreNetwork", CoreNetworkArgs.builder()
 *             .globalNetworkId(exampleGlobalNetwork.id())
 *             .basePolicyRegions(
 *                 "us-west-2",
 *                 "us-east-1")
 *             .createBasePolicy(true)
 *             .build());
 *         var exampleUsWest2 = new VpcAttachment("exampleUsWest2", VpcAttachmentArgs.builder()
 *             .coreNetworkId(exampleCoreNetwork.id())
 *             .subnetArns(aws_subnet.example_us_west_2().stream().map(element -> element.arn()).collect(toList()))
 *             .vpcArn(aws_vpc.example_us_west_2().arn())
 *             .build());
 *         var exampleUsEast1 = new VpcAttachment("exampleUsEast1", VpcAttachmentArgs.builder()
 *             .coreNetworkId(exampleCoreNetwork.id())
 *             .subnetArns(aws_subnet.example_us_east_1().stream().map(element -> element.arn()).collect(toList()))
 *             .vpcArn(aws_vpc.example_us_east_1().arn())
 *             .build(), CustomResourceOptions.builder()
 *                 .provider("alternate")
 *                 .build());
 *         final var exampleCoreNetworkPolicyDocument = NetworkmanagerFunctions.getCoreNetworkPolicyDocument(GetCoreNetworkPolicyDocumentArgs.builder()
 *             .coreNetworkConfigurations(GetCoreNetworkPolicyDocumentCoreNetworkConfigurationArgs.builder()
 *                 .asnRanges("65022-65534")
 *                 .edgeLocations(
 *                     GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocationArgs.builder()
 *                         .location("us-west-2")
 *                         .build(),
 *                     GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocationArgs.builder()
 *                         .location("us-east-1")
 *                         .build())
 *                 .build())
 *             .segments(
 *                 GetCoreNetworkPolicyDocumentSegmentArgs.builder()
 *                     .name("segment")
 *                     .build(),
 *                 GetCoreNetworkPolicyDocumentSegmentArgs.builder()
 *                     .name("segment2")
 *                     .build())
 *             .segmentActions(
 *                 GetCoreNetworkPolicyDocumentSegmentActionArgs.builder()
 *                     .action("create-route")
 *                     .segment("segment")
 *                     .destinationCidrBlocks("10.0.0.0/16")
 *                     .destinations(exampleUsWest2.id())
 *                     .build(),
 *                 GetCoreNetworkPolicyDocumentSegmentActionArgs.builder()
 *                     .action("create-route")
 *                     .segment("segment")
 *                     .destinationCidrBlocks("10.1.0.0/16")
 *                     .destinations(exampleUsEast1.id())
 *                     .build())
 *             .build());
 *         var exampleCoreNetworkPolicyAttachment = new CoreNetworkPolicyAttachment("exampleCoreNetworkPolicyAttachment", CoreNetworkPolicyAttachmentArgs.builder()
 *             .coreNetworkId(exampleCoreNetwork.id())
 *             .policyDocument(exampleCoreNetworkPolicyDocument.applyValue(getCoreNetworkPolicyDocumentResult -> getCoreNetworkPolicyDocumentResult).applyValue(exampleCoreNetworkPolicyDocument -> exampleCoreNetworkPolicyDocument.applyValue(getCoreNetworkPolicyDocumentResult -> getCoreNetworkPolicyDocumentResult.json())))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_networkmanager_core_network_policy_attachment` using the core network ID. For example:
 * ```sh
 *  $ pulumi import aws:networkmanager/coreNetworkPolicyAttachment:CoreNetworkPolicyAttachment example core-network-0d47f6t230mz46dy4
 * ```
 * @property coreNetworkId The ID of the core network that a policy will be attached to and made `LIVE`.
 * @property policyDocument Policy document for creating a core network. Note that updating this argument will result in the new policy document version being set as the `LATEST` and `LIVE` policy document. Refer to the [Core network policies documentation](https://docs.aws.amazon.com/network-manager/latest/cloudwan/cloudwan-policy-change-sets.html) for more information.
 */
public data class CoreNetworkPolicyAttachmentArgs(
    public val coreNetworkId: Output<String>? = null,
    public val policyDocument: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.networkmanager.CoreNetworkPolicyAttachmentArgs> {
    override fun toJava(): com.pulumi.aws.networkmanager.CoreNetworkPolicyAttachmentArgs =
        com.pulumi.aws.networkmanager.CoreNetworkPolicyAttachmentArgs.builder()
            .coreNetworkId(coreNetworkId?.applyValue({ args0 -> args0 }))
            .policyDocument(policyDocument?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CoreNetworkPolicyAttachmentArgs].
 */
@PulumiTagMarker
public class CoreNetworkPolicyAttachmentArgsBuilder internal constructor() {
    private var coreNetworkId: Output<String>? = null

    private var policyDocument: Output<String>? = null

    /**
     * @param value The ID of the core network that a policy will be attached to and made `LIVE`.
     */
    @JvmName("yswhfpkuwlnwkvmp")
    public suspend fun coreNetworkId(`value`: Output<String>) {
        this.coreNetworkId = value
    }

    /**
     * @param value Policy document for creating a core network. Note that updating this argument will result in the new policy document version being set as the `LATEST` and `LIVE` policy document. Refer to the [Core network policies documentation](https://docs.aws.amazon.com/network-manager/latest/cloudwan/cloudwan-policy-change-sets.html) for more information.
     */
    @JvmName("wwnyjrycpxeebngv")
    public suspend fun policyDocument(`value`: Output<String>) {
        this.policyDocument = value
    }

    /**
     * @param value The ID of the core network that a policy will be attached to and made `LIVE`.
     */
    @JvmName("ukonspvmbsmwdnjw")
    public suspend fun coreNetworkId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.coreNetworkId = mapped
    }

    /**
     * @param value Policy document for creating a core network. Note that updating this argument will result in the new policy document version being set as the `LATEST` and `LIVE` policy document. Refer to the [Core network policies documentation](https://docs.aws.amazon.com/network-manager/latest/cloudwan/cloudwan-policy-change-sets.html) for more information.
     */
    @JvmName("trgyahjhkwhjiqey")
    public suspend fun policyDocument(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyDocument = mapped
    }

    internal fun build(): CoreNetworkPolicyAttachmentArgs = CoreNetworkPolicyAttachmentArgs(
        coreNetworkId = coreNetworkId,
        policyDocument = policyDocument,
    )
}
