@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin

import com.pulumi.aws.networkmanager.CustomerGatewayAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Associates a customer gateway with a device and optionally, with a link.
 * If you specify a link, it must be associated with the specified device.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkmanager.GlobalNetwork;
 * import com.pulumi.aws.networkmanager.GlobalNetworkArgs;
 * import com.pulumi.aws.networkmanager.Site;
 * import com.pulumi.aws.networkmanager.SiteArgs;
 * import com.pulumi.aws.networkmanager.Device;
 * import com.pulumi.aws.networkmanager.DeviceArgs;
 * import com.pulumi.aws.ec2.CustomerGateway;
 * import com.pulumi.aws.ec2.CustomerGatewayArgs;
 * import com.pulumi.aws.ec2transitgateway.TransitGateway;
 * import com.pulumi.aws.ec2.VpnConnection;
 * import com.pulumi.aws.ec2.VpnConnectionArgs;
 * import com.pulumi.aws.networkmanager.TransitGatewayRegistration;
 * import com.pulumi.aws.networkmanager.TransitGatewayRegistrationArgs;
 * import com.pulumi.aws.networkmanager.CustomerGatewayAssociation;
 * import com.pulumi.aws.networkmanager.CustomerGatewayAssociationArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleGlobalNetwork = new GlobalNetwork("exampleGlobalNetwork", GlobalNetworkArgs.builder()
 *             .description("example")
 *             .build());
 *         var exampleSite = new Site("exampleSite", SiteArgs.builder()
 *             .globalNetworkId(exampleGlobalNetwork.id())
 *             .build());
 *         var exampleDevice = new Device("exampleDevice", DeviceArgs.builder()
 *             .globalNetworkId(exampleGlobalNetwork.id())
 *             .siteId(exampleSite.id())
 *             .build());
 *         var exampleCustomerGateway = new CustomerGateway("exampleCustomerGateway", CustomerGatewayArgs.builder()
 *             .bgpAsn(65000)
 *             .ipAddress("172.83.124.10")
 *             .type("ipsec.1")
 *             .build());
 *         var exampleTransitGateway = new TransitGateway("exampleTransitGateway");
 *         var exampleVpnConnection = new VpnConnection("exampleVpnConnection", VpnConnectionArgs.builder()
 *             .customerGatewayId(exampleCustomerGateway.id())
 *             .transitGatewayId(exampleTransitGateway.id())
 *             .type(exampleCustomerGateway.type())
 *             .staticRoutesOnly(true)
 *             .build());
 *         var exampleTransitGatewayRegistration = new TransitGatewayRegistration("exampleTransitGatewayRegistration", TransitGatewayRegistrationArgs.builder()
 *             .globalNetworkId(exampleGlobalNetwork.id())
 *             .transitGatewayArn(exampleTransitGateway.arn())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleVpnConnection)
 *                 .build());
 *         var exampleCustomerGatewayAssociation = new CustomerGatewayAssociation("exampleCustomerGatewayAssociation", CustomerGatewayAssociationArgs.builder()
 *             .globalNetworkId(exampleGlobalNetwork.id())
 *             .customerGatewayArn(exampleCustomerGateway.arn())
 *             .deviceId(exampleDevice.id())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleTransitGatewayRegistration)
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_networkmanager_customer_gateway_association` using the global network ID and customer gateway ARN. For example:
 * ```sh
 *  $ pulumi import aws:networkmanager/customerGatewayAssociation:CustomerGatewayAssociation example global-network-0d47f6t230mz46dy4,arn:aws:ec2:us-west-2:123456789012:customer-gateway/cgw-123abc05e04123abc
 * ```
 * @property customerGatewayArn The Amazon Resource Name (ARN) of the customer gateway.
 * @property deviceId The ID of the device.
 * @property globalNetworkId The ID of the global network.
 * @property linkId The ID of the link.
 */
public data class CustomerGatewayAssociationArgs(
    public val customerGatewayArn: Output<String>? = null,
    public val deviceId: Output<String>? = null,
    public val globalNetworkId: Output<String>? = null,
    public val linkId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.networkmanager.CustomerGatewayAssociationArgs> {
    override fun toJava(): com.pulumi.aws.networkmanager.CustomerGatewayAssociationArgs =
        com.pulumi.aws.networkmanager.CustomerGatewayAssociationArgs.builder()
            .customerGatewayArn(customerGatewayArn?.applyValue({ args0 -> args0 }))
            .deviceId(deviceId?.applyValue({ args0 -> args0 }))
            .globalNetworkId(globalNetworkId?.applyValue({ args0 -> args0 }))
            .linkId(linkId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CustomerGatewayAssociationArgs].
 */
@PulumiTagMarker
public class CustomerGatewayAssociationArgsBuilder internal constructor() {
    private var customerGatewayArn: Output<String>? = null

    private var deviceId: Output<String>? = null

    private var globalNetworkId: Output<String>? = null

    private var linkId: Output<String>? = null

    /**
     * @param value The Amazon Resource Name (ARN) of the customer gateway.
     */
    @JvmName("cihmenlmfbfvrjyp")
    public suspend fun customerGatewayArn(`value`: Output<String>) {
        this.customerGatewayArn = value
    }

    /**
     * @param value The ID of the device.
     */
    @JvmName("cadjmbpxfuicwanr")
    public suspend fun deviceId(`value`: Output<String>) {
        this.deviceId = value
    }

    /**
     * @param value The ID of the global network.
     */
    @JvmName("bedoeabwrbghdgca")
    public suspend fun globalNetworkId(`value`: Output<String>) {
        this.globalNetworkId = value
    }

    /**
     * @param value The ID of the link.
     */
    @JvmName("smgujjmyprpnsbdd")
    public suspend fun linkId(`value`: Output<String>) {
        this.linkId = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the customer gateway.
     */
    @JvmName("ihdmslbyqiwgflkc")
    public suspend fun customerGatewayArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customerGatewayArn = mapped
    }

    /**
     * @param value The ID of the device.
     */
    @JvmName("dlgqhfiugjvxswvv")
    public suspend fun deviceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deviceId = mapped
    }

    /**
     * @param value The ID of the global network.
     */
    @JvmName("qeaewuspickandoa")
    public suspend fun globalNetworkId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.globalNetworkId = mapped
    }

    /**
     * @param value The ID of the link.
     */
    @JvmName("dygidwvhutbymfbk")
    public suspend fun linkId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linkId = mapped
    }

    internal fun build(): CustomerGatewayAssociationArgs = CustomerGatewayAssociationArgs(
        customerGatewayArn = customerGatewayArn,
        deviceId = deviceId,
        globalNetworkId = globalNetworkId,
        linkId = linkId,
    )
}
