@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin

import com.pulumi.aws.networkmanager.kotlin.outputs.DeviceAwsLocation
import com.pulumi.aws.networkmanager.kotlin.outputs.DeviceLocation
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.networkmanager.kotlin.outputs.DeviceAwsLocation.Companion.toKotlin as deviceAwsLocationToKotlin
import com.pulumi.aws.networkmanager.kotlin.outputs.DeviceLocation.Companion.toKotlin as deviceLocationToKotlin

/**
 * Builder for [Device].
 */
@PulumiTagMarker
public class DeviceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DeviceArgs = DeviceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DeviceArgsBuilder.() -> Unit) {
        val builder = DeviceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Device {
        val builtJavaResource = com.pulumi.aws.networkmanager.Device(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Device(builtJavaResource)
    }
}

/**
 * Creates a device in a global network. If you specify both a site ID and a location,
 * the location of the site is used for visualization in the Network Manager console.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkmanager.Device;
 * import com.pulumi.aws.networkmanager.DeviceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Device("example", DeviceArgs.builder()
 *             .globalNetworkId(aws_networkmanager_global_network.example().id())
 *             .siteId(aws_networkmanager_site.example().id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_networkmanager_device` using the device ARN. For example:
 * ```sh
 *  $ pulumi import aws:networkmanager/device:Device example arn:aws:networkmanager::123456789012:device/global-network-0d47f6t230mz46dy4/device-07f6fd08867abc123
 * ```
 *
 */
public class Device internal constructor(
    override val javaResource: com.pulumi.aws.networkmanager.Device,
) : KotlinCustomResource(javaResource, DeviceMapper) {
    /**
     * The Amazon Resource Name (ARN) of the device.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The AWS location of the device. Documented below.
     */
    public val awsLocation: Output<DeviceAwsLocation>?
        get() = javaResource.awsLocation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    deviceAwsLocationToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * A description of the device.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the global network.
     */
    public val globalNetworkId: Output<String>
        get() = javaResource.globalNetworkId().applyValue({ args0 -> args0 })

    /**
     * The location of the device. Documented below.
     */
    public val location: Output<DeviceLocation>?
        get() = javaResource.location().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    deviceLocationToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The model of device.
     */
    public val model: Output<String>?
        get() = javaResource.model().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The serial number of the device.
     */
    public val serialNumber: Output<String>?
        get() = javaResource.serialNumber().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the site.
     */
    public val siteId: Output<String>?
        get() = javaResource.siteId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Key-value tags for the device. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The type of device.
     */
    public val type: Output<String>?
        get() = javaResource.type().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The vendor of the device.
     */
    public val vendor: Output<String>?
        get() = javaResource.vendor().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object DeviceMapper : ResourceMapper<Device> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.networkmanager.Device::class == javaResource::class

    override fun map(javaResource: Resource): Device = Device(
        javaResource as
            com.pulumi.aws.networkmanager.Device,
    )
}

/**
 * @see [Device].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Device].
 */
public suspend fun device(name: String, block: suspend DeviceResourceBuilder.() -> Unit): Device {
    val builder = DeviceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Device].
 * @param name The _unique_ name of the resulting resource.
 */
public fun device(name: String): Device {
    val builder = DeviceResourceBuilder()
    builder.name(name)
    return builder.build()
}
