@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin

import com.pulumi.aws.networkmanager.kotlin.outputs.LinkBandwidth
import com.pulumi.aws.networkmanager.kotlin.outputs.LinkBandwidth.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Link].
 */
@PulumiTagMarker
public class LinkResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LinkArgs = LinkArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LinkArgsBuilder.() -> Unit) {
        val builder = LinkArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Link {
        val builtJavaResource = com.pulumi.aws.networkmanager.Link(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Link(builtJavaResource)
    }
}

/**
 * Creates a link for a site.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkmanager.Link;
 * import com.pulumi.aws.networkmanager.LinkArgs;
 * import com.pulumi.aws.networkmanager.inputs.LinkBandwidthArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Link("example", LinkArgs.builder()
 *             .globalNetworkId(aws_networkmanager_global_network.example().id())
 *             .siteId(aws_networkmanager_site.example().id())
 *             .bandwidth(LinkBandwidthArgs.builder()
 *                 .uploadSpeed(10)
 *                 .downloadSpeed(50)
 *                 .build())
 *             .providerName("MegaCorp")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_networkmanager_link` using the link ARN. For example:
 * ```sh
 *  $ pulumi import aws:networkmanager/link:Link example arn:aws:networkmanager::123456789012:link/global-network-0d47f6t230mz46dy4/link-444555aaabbb11223
 * ```
 *
 */
public class Link internal constructor(
    override val javaResource: com.pulumi.aws.networkmanager.Link,
) : KotlinCustomResource(javaResource, LinkMapper) {
    /**
     * Link Amazon Resource Name (ARN).
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The upload speed and download speed in Mbps. Documented below.
     */
    public val bandwidth: Output<LinkBandwidth>
        get() = javaResource.bandwidth().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * A description of the link.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the global network.
     */
    public val globalNetworkId: Output<String>
        get() = javaResource.globalNetworkId().applyValue({ args0 -> args0 })

    /**
     * The provider of the link.
     */
    public val providerName: Output<String>?
        get() = javaResource.providerName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the site.
     */
    public val siteId: Output<String>
        get() = javaResource.siteId().applyValue({ args0 -> args0 })

    /**
     * Key-value tags for the link. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The type of the link.
     */
    public val type: Output<String>?
        get() = javaResource.type().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object LinkMapper : ResourceMapper<Link> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.networkmanager.Link::class == javaResource::class

    override fun map(javaResource: Resource): Link = Link(
        javaResource as
            com.pulumi.aws.networkmanager.Link,
    )
}

/**
 * @see [Link].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Link].
 */
public suspend fun link(name: String, block: suspend LinkResourceBuilder.() -> Unit): Link {
    val builder = LinkResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Link].
 * @param name The _unique_ name of the resulting resource.
 */
public fun link(name: String): Link {
    val builder = LinkResourceBuilder()
    builder.name(name)
    return builder.build()
}
