@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin

import com.pulumi.aws.networkmanager.LinkAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Associates a link to a device.
 * A device can be associated to multiple links and a link can be associated to multiple devices.
 * The device and link must be in the same global network and the same site.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkmanager.LinkAssociation;
 * import com.pulumi.aws.networkmanager.LinkAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new LinkAssociation("example", LinkAssociationArgs.builder()
 *             .globalNetworkId(aws_networkmanager_global_network.example().id())
 *             .linkId(aws_networkmanager_link.example().id())
 *             .deviceId(aws_networkmanager_device.example().id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_networkmanager_link_association` using the global network ID, link ID and device ID. For example:
 * ```sh
 *  $ pulumi import aws:networkmanager/linkAssociation:LinkAssociation example global-network-0d47f6t230mz46dy4,link-444555aaabbb11223,device-07f6fd08867abc123
 * ```
 * @property deviceId The ID of the device.
 * @property globalNetworkId The ID of the global network.
 * @property linkId The ID of the link.
 */
public data class LinkAssociationArgs(
    public val deviceId: Output<String>? = null,
    public val globalNetworkId: Output<String>? = null,
    public val linkId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.networkmanager.LinkAssociationArgs> {
    override fun toJava(): com.pulumi.aws.networkmanager.LinkAssociationArgs =
        com.pulumi.aws.networkmanager.LinkAssociationArgs.builder()
            .deviceId(deviceId?.applyValue({ args0 -> args0 }))
            .globalNetworkId(globalNetworkId?.applyValue({ args0 -> args0 }))
            .linkId(linkId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LinkAssociationArgs].
 */
@PulumiTagMarker
public class LinkAssociationArgsBuilder internal constructor() {
    private var deviceId: Output<String>? = null

    private var globalNetworkId: Output<String>? = null

    private var linkId: Output<String>? = null

    /**
     * @param value The ID of the device.
     */
    @JvmName("aclvbsxplarwdfqy")
    public suspend fun deviceId(`value`: Output<String>) {
        this.deviceId = value
    }

    /**
     * @param value The ID of the global network.
     */
    @JvmName("fuygeijpmvglvqmc")
    public suspend fun globalNetworkId(`value`: Output<String>) {
        this.globalNetworkId = value
    }

    /**
     * @param value The ID of the link.
     */
    @JvmName("uranebflvjfkigsx")
    public suspend fun linkId(`value`: Output<String>) {
        this.linkId = value
    }

    /**
     * @param value The ID of the device.
     */
    @JvmName("rdxaklhruotjblya")
    public suspend fun deviceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deviceId = mapped
    }

    /**
     * @param value The ID of the global network.
     */
    @JvmName("uuphyetgqrjxibsv")
    public suspend fun globalNetworkId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.globalNetworkId = mapped
    }

    /**
     * @param value The ID of the link.
     */
    @JvmName("eqcexrekuciitxxk")
    public suspend fun linkId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linkId = mapped
    }

    internal fun build(): LinkAssociationArgs = LinkAssociationArgs(
        deviceId = deviceId,
        globalNetworkId = globalNetworkId,
        linkId = linkId,
    )
}
