@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin

import com.pulumi.aws.networkmanager.NetworkmanagerFunctions.getConnectionPlain
import com.pulumi.aws.networkmanager.NetworkmanagerFunctions.getConnectionsPlain
import com.pulumi.aws.networkmanager.NetworkmanagerFunctions.getCoreNetworkPolicyDocumentPlain
import com.pulumi.aws.networkmanager.NetworkmanagerFunctions.getDevicePlain
import com.pulumi.aws.networkmanager.NetworkmanagerFunctions.getDevicesPlain
import com.pulumi.aws.networkmanager.NetworkmanagerFunctions.getGlobalNetworkPlain
import com.pulumi.aws.networkmanager.NetworkmanagerFunctions.getGlobalNetworksPlain
import com.pulumi.aws.networkmanager.NetworkmanagerFunctions.getLinkPlain
import com.pulumi.aws.networkmanager.NetworkmanagerFunctions.getLinksPlain
import com.pulumi.aws.networkmanager.NetworkmanagerFunctions.getSitePlain
import com.pulumi.aws.networkmanager.NetworkmanagerFunctions.getSitesPlain
import com.pulumi.aws.networkmanager.kotlin.inputs.GetConnectionPlainArgs
import com.pulumi.aws.networkmanager.kotlin.inputs.GetConnectionPlainArgsBuilder
import com.pulumi.aws.networkmanager.kotlin.inputs.GetConnectionsPlainArgs
import com.pulumi.aws.networkmanager.kotlin.inputs.GetConnectionsPlainArgsBuilder
import com.pulumi.aws.networkmanager.kotlin.inputs.GetCoreNetworkPolicyDocumentAttachmentPolicy
import com.pulumi.aws.networkmanager.kotlin.inputs.GetCoreNetworkPolicyDocumentCoreNetworkConfiguration
import com.pulumi.aws.networkmanager.kotlin.inputs.GetCoreNetworkPolicyDocumentPlainArgs
import com.pulumi.aws.networkmanager.kotlin.inputs.GetCoreNetworkPolicyDocumentPlainArgsBuilder
import com.pulumi.aws.networkmanager.kotlin.inputs.GetCoreNetworkPolicyDocumentSegment
import com.pulumi.aws.networkmanager.kotlin.inputs.GetCoreNetworkPolicyDocumentSegmentAction
import com.pulumi.aws.networkmanager.kotlin.inputs.GetDevicePlainArgs
import com.pulumi.aws.networkmanager.kotlin.inputs.GetDevicePlainArgsBuilder
import com.pulumi.aws.networkmanager.kotlin.inputs.GetDevicesPlainArgs
import com.pulumi.aws.networkmanager.kotlin.inputs.GetDevicesPlainArgsBuilder
import com.pulumi.aws.networkmanager.kotlin.inputs.GetGlobalNetworkPlainArgs
import com.pulumi.aws.networkmanager.kotlin.inputs.GetGlobalNetworkPlainArgsBuilder
import com.pulumi.aws.networkmanager.kotlin.inputs.GetGlobalNetworksPlainArgs
import com.pulumi.aws.networkmanager.kotlin.inputs.GetGlobalNetworksPlainArgsBuilder
import com.pulumi.aws.networkmanager.kotlin.inputs.GetLinkPlainArgs
import com.pulumi.aws.networkmanager.kotlin.inputs.GetLinkPlainArgsBuilder
import com.pulumi.aws.networkmanager.kotlin.inputs.GetLinksPlainArgs
import com.pulumi.aws.networkmanager.kotlin.inputs.GetLinksPlainArgsBuilder
import com.pulumi.aws.networkmanager.kotlin.inputs.GetSitePlainArgs
import com.pulumi.aws.networkmanager.kotlin.inputs.GetSitePlainArgsBuilder
import com.pulumi.aws.networkmanager.kotlin.inputs.GetSitesPlainArgs
import com.pulumi.aws.networkmanager.kotlin.inputs.GetSitesPlainArgsBuilder
import com.pulumi.aws.networkmanager.kotlin.outputs.GetConnectionResult
import com.pulumi.aws.networkmanager.kotlin.outputs.GetConnectionsResult
import com.pulumi.aws.networkmanager.kotlin.outputs.GetCoreNetworkPolicyDocumentResult
import com.pulumi.aws.networkmanager.kotlin.outputs.GetDeviceResult
import com.pulumi.aws.networkmanager.kotlin.outputs.GetDevicesResult
import com.pulumi.aws.networkmanager.kotlin.outputs.GetGlobalNetworkResult
import com.pulumi.aws.networkmanager.kotlin.outputs.GetGlobalNetworksResult
import com.pulumi.aws.networkmanager.kotlin.outputs.GetLinkResult
import com.pulumi.aws.networkmanager.kotlin.outputs.GetLinksResult
import com.pulumi.aws.networkmanager.kotlin.outputs.GetSiteResult
import com.pulumi.aws.networkmanager.kotlin.outputs.GetSitesResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.networkmanager.kotlin.outputs.GetConnectionResult.Companion.toKotlin as getConnectionResultToKotlin
import com.pulumi.aws.networkmanager.kotlin.outputs.GetConnectionsResult.Companion.toKotlin as getConnectionsResultToKotlin
import com.pulumi.aws.networkmanager.kotlin.outputs.GetCoreNetworkPolicyDocumentResult.Companion.toKotlin as getCoreNetworkPolicyDocumentResultToKotlin
import com.pulumi.aws.networkmanager.kotlin.outputs.GetDeviceResult.Companion.toKotlin as getDeviceResultToKotlin
import com.pulumi.aws.networkmanager.kotlin.outputs.GetDevicesResult.Companion.toKotlin as getDevicesResultToKotlin
import com.pulumi.aws.networkmanager.kotlin.outputs.GetGlobalNetworkResult.Companion.toKotlin as getGlobalNetworkResultToKotlin
import com.pulumi.aws.networkmanager.kotlin.outputs.GetGlobalNetworksResult.Companion.toKotlin as getGlobalNetworksResultToKotlin
import com.pulumi.aws.networkmanager.kotlin.outputs.GetLinkResult.Companion.toKotlin as getLinkResultToKotlin
import com.pulumi.aws.networkmanager.kotlin.outputs.GetLinksResult.Companion.toKotlin as getLinksResultToKotlin
import com.pulumi.aws.networkmanager.kotlin.outputs.GetSiteResult.Companion.toKotlin as getSiteResultToKotlin
import com.pulumi.aws.networkmanager.kotlin.outputs.GetSitesResult.Companion.toKotlin as getSitesResultToKotlin

public object NetworkmanagerFunctions {
    /**
     * Retrieve information about a connection.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.networkmanager.NetworkmanagerFunctions;
     * import com.pulumi.aws.networkmanager.inputs.GetConnectionArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = NetworkmanagerFunctions.getConnection(GetConnectionArgs.builder()
     *             .globalNetworkId(var_.global_network_id())
     *             .connectionId(var_.connection_id())
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getConnection.
     * @return A collection of values returned by getConnection.
     */
    public suspend fun getConnection(argument: GetConnectionPlainArgs): GetConnectionResult =
        getConnectionResultToKotlin(getConnectionPlain(argument.toJava()).await())

    /**
     * @see [getConnection].
     * @param connectionId ID of the specific connection to retrieve.
     * @param globalNetworkId ID of the Global Network of the connection to retrieve.
     * @param tags Key-value tags for the connection.
     * @return A collection of values returned by getConnection.
     */
    public suspend fun getConnection(
        connectionId: String,
        globalNetworkId: String,
        tags: Map<String, String>? = null,
    ): GetConnectionResult {
        val argument = GetConnectionPlainArgs(
            connectionId = connectionId,
            globalNetworkId = globalNetworkId,
            tags = tags,
        )
        return getConnectionResultToKotlin(getConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getConnection].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;networkmanager&#46;kotlin&#46;inputs&#46;GetConnectionPlainArgs].
     * @return A collection of values returned by getConnection.
     */
    public suspend fun getConnection(argument: suspend GetConnectionPlainArgsBuilder.() -> Unit):
        GetConnectionResult {
        val builder = GetConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getConnectionResultToKotlin(getConnectionPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve information about connections.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.networkmanager.NetworkmanagerFunctions;
     * import com.pulumi.aws.networkmanager.inputs.GetConnectionsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = NetworkmanagerFunctions.getConnections(GetConnectionsArgs.builder()
     *             .globalNetworkId(var_.global_network_id())
     *             .tags(Map.of("Env", "test"))
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getConnections.
     * @return A collection of values returned by getConnections.
     */
    public suspend fun getConnections(argument: GetConnectionsPlainArgs): GetConnectionsResult =
        getConnectionsResultToKotlin(getConnectionsPlain(argument.toJava()).await())

    /**
     * @see [getConnections].
     * @param deviceId ID of the device of the connections to retrieve.
     * @param globalNetworkId ID of the Global Network of the connections to retrieve.
     * @param tags Restricts the list to the connections with these tags.
     * @return A collection of values returned by getConnections.
     */
    public suspend fun getConnections(
        deviceId: String? = null,
        globalNetworkId: String,
        tags: Map<String, String>? = null,
    ): GetConnectionsResult {
        val argument = GetConnectionsPlainArgs(
            deviceId = deviceId,
            globalNetworkId = globalNetworkId,
            tags = tags,
        )
        return getConnectionsResultToKotlin(getConnectionsPlain(argument.toJava()).await())
    }

    /**
     * @see [getConnections].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;networkmanager&#46;kotlin&#46;inputs&#46;GetConnectionsPlainArgs].
     * @return A collection of values returned by getConnections.
     */
    public suspend fun getConnections(argument: suspend GetConnectionsPlainArgsBuilder.() -> Unit):
        GetConnectionsResult {
        val builder = GetConnectionsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getConnectionsResultToKotlin(getConnectionsPlain(builtArgument.toJava()).await())
    }

    /**
     * Generates a Core Network policy document in JSON format for use with resources that expect core network policy documents such as `awscc_networkmanager_core_network`. It follows the API definition from the [core-network-policy documentation](https://docs.aws.amazon.com/vpc/latest/cloudwan/cloudwan-policies-json.html).
     * Using this data source to generate policy documents is *optional*. It is also valid to use literal JSON strings in your configuration or to use the `file` interpolation function to read a raw JSON policy document from a file.
     * ## Example Usage
     * ### Basic Example
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.networkmanager.NetworkmanagerFunctions;
     * import com.pulumi.aws.networkmanager.inputs.GetCoreNetworkPolicyDocumentArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = NetworkmanagerFunctions.getCoreNetworkPolicyDocument(GetCoreNetworkPolicyDocumentArgs.builder()
     *             .attachmentPolicies(
     *                 GetCoreNetworkPolicyDocumentAttachmentPolicyArgs.builder()
     *                     .action(GetCoreNetworkPolicyDocumentAttachmentPolicyActionArgs.builder()
     *                         .associationMethod("constant")
     *                         .segment("shared")
     *                         .build())
     *                     .conditionLogic("or")
     *                     .conditions(GetCoreNetworkPolicyDocumentAttachmentPolicyConditionArgs.builder()
     *                         .key("segment")
     *                         .operator("equals")
     *                         .type("tag-value")
     *                         .value("shared")
     *                         .build())
     *                     .ruleNumber(100)
     *                     .build(),
     *                 GetCoreNetworkPolicyDocumentAttachmentPolicyArgs.builder()
     *                     .action(GetCoreNetworkPolicyDocumentAttachmentPolicyActionArgs.builder()
     *                         .associationMethod("constant")
     *                         .segment("prod")
     *                         .build())
     *                     .conditionLogic("or")
     *                     .conditions(GetCoreNetworkPolicyDocumentAttachmentPolicyConditionArgs.builder()
     *                         .key("segment")
     *                         .operator("equals")
     *                         .type("tag-value")
     *                         .value("prod")
     *                         .build())
     *                     .ruleNumber(200)
     *                     .build())
     *             .coreNetworkConfigurations(GetCoreNetworkPolicyDocumentCoreNetworkConfigurationArgs.builder()
     *                 .asnRanges("64512-64555")
     *                 .edgeLocations(
     *                     GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocationArgs.builder()
     *                         .asn(64512)
     *                         .location("us-east-1")
     *                         .build(),
     *                     GetCoreNetworkPolicyDocumentCoreNetworkConfigurationEdgeLocationArgs.builder()
     *                         .asn(64513)
     *                         .location("eu-central-1")
     *                         .build())
     *                 .vpnEcmpSupport(false)
     *                 .build())
     *             .segmentActions(GetCoreNetworkPolicyDocumentSegmentActionArgs.builder()
     *                 .action("share")
     *                 .mode("attachment-route")
     *                 .segment("shared")
     *                 .shareWiths("*")
     *                 .build())
     *             .segments(
     *                 GetCoreNetworkPolicyDocumentSegmentArgs.builder()
     *                     .description("Segment for shared services")
     *                     .name("shared")
     *                     .requireAttachmentAcceptance(true)
     *                     .build(),
     *                 GetCoreNetworkPolicyDocumentSegmentArgs.builder()
     *                     .description("Segment for prod services")
     *                     .name("prod")
     *                     .requireAttachmentAcceptance(true)
     *                     .build())
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getCoreNetworkPolicyDocument.
     * @return A collection of values returned by getCoreNetworkPolicyDocument.
     */
    public suspend fun getCoreNetworkPolicyDocument(argument: GetCoreNetworkPolicyDocumentPlainArgs):
        GetCoreNetworkPolicyDocumentResult =
        getCoreNetworkPolicyDocumentResultToKotlin(getCoreNetworkPolicyDocumentPlain(argument.toJava()).await())

    /**
     * @see [getCoreNetworkPolicyDocument].
     * @param attachmentPolicies In a core network, all attachments use the block argument `attachment_policies` section to map an attachment to a segment. Instead of manually associating a segment to each attachment, attachments use tags, and then the tags are used to associate the attachment to the specified segment. Detailed below.
     * @param coreNetworkConfigurations The core network configuration section defines the Regions where a core network should operate. For AWS Regions that are defined in the policy, the core network creates a Core Network Edge where you can connect attachments. After it's created, each Core Network Edge is peered with every other defined Region and is configured with consistent segment and routing across all Regions. Regions cannot be removed until the associated attachments are deleted. Detailed below.
     * @param segmentActions A block argument, `segment_actions` define how routing works between segments. By default, attachments can only communicate with other attachments in the same segment. Detailed below.
     * @param segments Block argument that defines the different segments in the network. Here you can provide descriptions, change defaults, and provide explicit Regional operational and route filters. The names defined for each segment are used in the `segment_actions` and `attachment_policies` section. Each segment is created, and operates, as a completely separated routing domain. By default, attachments can only communicate with other attachments in the same segment. Detailed below.
     * @param version
     * @return A collection of values returned by getCoreNetworkPolicyDocument.
     */
    public suspend fun getCoreNetworkPolicyDocument(
        attachmentPolicies: List<GetCoreNetworkPolicyDocumentAttachmentPolicy>? = null,
        coreNetworkConfigurations: List<GetCoreNetworkPolicyDocumentCoreNetworkConfiguration>,
        segmentActions: List<GetCoreNetworkPolicyDocumentSegmentAction>? = null,
        segments: List<GetCoreNetworkPolicyDocumentSegment>,
        version: String? = null,
    ): GetCoreNetworkPolicyDocumentResult {
        val argument = GetCoreNetworkPolicyDocumentPlainArgs(
            attachmentPolicies = attachmentPolicies,
            coreNetworkConfigurations = coreNetworkConfigurations,
            segmentActions = segmentActions,
            segments = segments,
            version = version,
        )
        return getCoreNetworkPolicyDocumentResultToKotlin(getCoreNetworkPolicyDocumentPlain(argument.toJava()).await())
    }

    /**
     * @see [getCoreNetworkPolicyDocument].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;networkmanager&#46;kotlin&#46;inputs&#46;GetCoreNetworkPolicyDocumentPlainArgs].
     * @return A collection of values returned by getCoreNetworkPolicyDocument.
     */
    public suspend
    fun getCoreNetworkPolicyDocument(argument: suspend GetCoreNetworkPolicyDocumentPlainArgsBuilder.() -> Unit):
        GetCoreNetworkPolicyDocumentResult {
        val builder = GetCoreNetworkPolicyDocumentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCoreNetworkPolicyDocumentResultToKotlin(getCoreNetworkPolicyDocumentPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve information about a device.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.networkmanager.NetworkmanagerFunctions;
     * import com.pulumi.aws.networkmanager.inputs.GetDeviceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = NetworkmanagerFunctions.getDevice(GetDeviceArgs.builder()
     *             .globalNetworkIdId(var_.global_network_id())
     *             .deviceId(var_.device_id())
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getDevice.
     * @return A collection of values returned by getDevice.
     */
    public suspend fun getDevice(argument: GetDevicePlainArgs): GetDeviceResult =
        getDeviceResultToKotlin(getDevicePlain(argument.toJava()).await())

    /**
     * @see [getDevice].
     * @param deviceId ID of the device.
     * @param globalNetworkId ID of the global network.
     * @param tags Key-value tags for the device.
     * @return A collection of values returned by getDevice.
     */
    public suspend fun getDevice(
        deviceId: String,
        globalNetworkId: String,
        tags: Map<String, String>? = null,
    ): GetDeviceResult {
        val argument = GetDevicePlainArgs(
            deviceId = deviceId,
            globalNetworkId = globalNetworkId,
            tags = tags,
        )
        return getDeviceResultToKotlin(getDevicePlain(argument.toJava()).await())
    }

    /**
     * @see [getDevice].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;networkmanager&#46;kotlin&#46;inputs&#46;GetDevicePlainArgs].
     * @return A collection of values returned by getDevice.
     */
    public suspend fun getDevice(argument: suspend GetDevicePlainArgsBuilder.() -> Unit):
        GetDeviceResult {
        val builder = GetDevicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDeviceResultToKotlin(getDevicePlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve information about devices.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.networkmanager.NetworkmanagerFunctions;
     * import com.pulumi.aws.networkmanager.inputs.GetDevicesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = NetworkmanagerFunctions.getDevices(GetDevicesArgs.builder()
     *             .globalNetworkId(var_.global_network_id())
     *             .tags(Map.of("Env", "test"))
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getDevices.
     * @return A collection of values returned by getDevices.
     */
    public suspend fun getDevices(argument: GetDevicesPlainArgs): GetDevicesResult =
        getDevicesResultToKotlin(getDevicesPlain(argument.toJava()).await())

    /**
     * @see [getDevices].
     * @param globalNetworkId ID of the Global Network of the devices to retrieve.
     * @param siteId ID of the site of the devices to retrieve.
     * @param tags Restricts the list to the devices with these tags.
     * @return A collection of values returned by getDevices.
     */
    public suspend fun getDevices(
        globalNetworkId: String,
        siteId: String? = null,
        tags: Map<String, String>? = null,
    ): GetDevicesResult {
        val argument = GetDevicesPlainArgs(
            globalNetworkId = globalNetworkId,
            siteId = siteId,
            tags = tags,
        )
        return getDevicesResultToKotlin(getDevicesPlain(argument.toJava()).await())
    }

    /**
     * @see [getDevices].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;networkmanager&#46;kotlin&#46;inputs&#46;GetDevicesPlainArgs].
     * @return A collection of values returned by getDevices.
     */
    public suspend fun getDevices(argument: suspend GetDevicesPlainArgsBuilder.() -> Unit):
        GetDevicesResult {
        val builder = GetDevicesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDevicesResultToKotlin(getDevicesPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve information about a global network.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.networkmanager.NetworkmanagerFunctions;
     * import com.pulumi.aws.networkmanager.inputs.GetGlobalNetworkArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = NetworkmanagerFunctions.getGlobalNetwork(GetGlobalNetworkArgs.builder()
     *             .globalNetworkId(var_.global_network_id())
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getGlobalNetwork.
     * @return A collection of values returned by getGlobalNetwork.
     */
    public suspend fun getGlobalNetwork(argument: GetGlobalNetworkPlainArgs): GetGlobalNetworkResult =
        getGlobalNetworkResultToKotlin(getGlobalNetworkPlain(argument.toJava()).await())

    /**
     * @see [getGlobalNetwork].
     * @param globalNetworkId ID of the specific global network to retrieve.
     * @param tags Map of resource tags.
     * @return A collection of values returned by getGlobalNetwork.
     */
    public suspend fun getGlobalNetwork(globalNetworkId: String, tags: Map<String, String>? = null):
        GetGlobalNetworkResult {
        val argument = GetGlobalNetworkPlainArgs(
            globalNetworkId = globalNetworkId,
            tags = tags,
        )
        return getGlobalNetworkResultToKotlin(getGlobalNetworkPlain(argument.toJava()).await())
    }

    /**
     * @see [getGlobalNetwork].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;networkmanager&#46;kotlin&#46;inputs&#46;GetGlobalNetworkPlainArgs].
     * @return A collection of values returned by getGlobalNetwork.
     */
    public suspend
    fun getGlobalNetwork(argument: suspend GetGlobalNetworkPlainArgsBuilder.() -> Unit):
        GetGlobalNetworkResult {
        val builder = GetGlobalNetworkPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGlobalNetworkResultToKotlin(getGlobalNetworkPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve information about global networks.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.networkmanager.NetworkmanagerFunctions;
     * import com.pulumi.aws.networkmanager.inputs.GetGlobalNetworksArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = NetworkmanagerFunctions.getGlobalNetworks(GetGlobalNetworksArgs.builder()
     *             .tags(Map.of("Env", "test"))
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getGlobalNetworks.
     * @return A collection of values returned by getGlobalNetworks.
     */
    public suspend fun getGlobalNetworks(argument: GetGlobalNetworksPlainArgs):
        GetGlobalNetworksResult =
        getGlobalNetworksResultToKotlin(getGlobalNetworksPlain(argument.toJava()).await())

    /**
     * @see [getGlobalNetworks].
     * @param tags Restricts the list to the global networks with these tags.
     * @return A collection of values returned by getGlobalNetworks.
     */
    public suspend fun getGlobalNetworks(tags: Map<String, String>? = null): GetGlobalNetworksResult {
        val argument = GetGlobalNetworksPlainArgs(
            tags = tags,
        )
        return getGlobalNetworksResultToKotlin(getGlobalNetworksPlain(argument.toJava()).await())
    }

    /**
     * @see [getGlobalNetworks].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;networkmanager&#46;kotlin&#46;inputs&#46;GetGlobalNetworksPlainArgs].
     * @return A collection of values returned by getGlobalNetworks.
     */
    public suspend
    fun getGlobalNetworks(argument: suspend GetGlobalNetworksPlainArgsBuilder.() -> Unit):
        GetGlobalNetworksResult {
        val builder = GetGlobalNetworksPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGlobalNetworksResultToKotlin(getGlobalNetworksPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve information about a link.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.networkmanager.NetworkmanagerFunctions;
     * import com.pulumi.aws.networkmanager.inputs.GetLinkArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = NetworkmanagerFunctions.getLink(GetLinkArgs.builder()
     *             .globalNetworkId(var_.global_network_id())
     *             .linkId(var_.link_id())
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getLink.
     * @return A collection of values returned by getLink.
     */
    public suspend fun getLink(argument: GetLinkPlainArgs): GetLinkResult =
        getLinkResultToKotlin(getLinkPlain(argument.toJava()).await())

    /**
     * @see [getLink].
     * @param globalNetworkId ID of the Global Network of the link to retrieve.
     * @param linkId ID of the specific link to retrieve.
     * @param tags Key-value tags for the link.
     * @return A collection of values returned by getLink.
     */
    public suspend fun getLink(
        globalNetworkId: String,
        linkId: String,
        tags: Map<String, String>? = null,
    ): GetLinkResult {
        val argument = GetLinkPlainArgs(
            globalNetworkId = globalNetworkId,
            linkId = linkId,
            tags = tags,
        )
        return getLinkResultToKotlin(getLinkPlain(argument.toJava()).await())
    }

    /**
     * @see [getLink].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;networkmanager&#46;kotlin&#46;inputs&#46;GetLinkPlainArgs].
     * @return A collection of values returned by getLink.
     */
    public suspend fun getLink(argument: suspend GetLinkPlainArgsBuilder.() -> Unit): GetLinkResult {
        val builder = GetLinkPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLinkResultToKotlin(getLinkPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve information about link.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.networkmanager.NetworkmanagerFunctions;
     * import com.pulumi.aws.networkmanager.inputs.GetLinksArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = NetworkmanagerFunctions.getLinks(GetLinksArgs.builder()
     *             .globalNetworkId(var_.global_network_id())
     *             .tags(Map.of("Env", "test"))
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getLinks.
     * @return A collection of values returned by getLinks.
     */
    public suspend fun getLinks(argument: GetLinksPlainArgs): GetLinksResult =
        getLinksResultToKotlin(getLinksPlain(argument.toJava()).await())

    /**
     * @see [getLinks].
     * @param globalNetworkId ID of the Global Network of the links to retrieve.
     * @param providerName Link provider to retrieve.
     * @param siteId ID of the site of the links to retrieve.
     * @param tags Restricts the list to the links with these tags.
     * @param type Link type to retrieve.
     * @return A collection of values returned by getLinks.
     */
    public suspend fun getLinks(
        globalNetworkId: String,
        providerName: String? = null,
        siteId: String? = null,
        tags: Map<String, String>? = null,
        type: String? = null,
    ): GetLinksResult {
        val argument = GetLinksPlainArgs(
            globalNetworkId = globalNetworkId,
            providerName = providerName,
            siteId = siteId,
            tags = tags,
            type = type,
        )
        return getLinksResultToKotlin(getLinksPlain(argument.toJava()).await())
    }

    /**
     * @see [getLinks].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;networkmanager&#46;kotlin&#46;inputs&#46;GetLinksPlainArgs].
     * @return A collection of values returned by getLinks.
     */
    public suspend fun getLinks(argument: suspend GetLinksPlainArgsBuilder.() -> Unit):
        GetLinksResult {
        val builder = GetLinksPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLinksResultToKotlin(getLinksPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve information about a site.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.networkmanager.NetworkmanagerFunctions;
     * import com.pulumi.aws.networkmanager.inputs.GetSiteArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = NetworkmanagerFunctions.getSite(GetSiteArgs.builder()
     *             .globalNetworkId(var_.global_network_id())
     *             .siteId(var_.site_id())
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getSite.
     * @return A collection of values returned by getSite.
     */
    public suspend fun getSite(argument: GetSitePlainArgs): GetSiteResult =
        getSiteResultToKotlin(getSitePlain(argument.toJava()).await())

    /**
     * @see [getSite].
     * @param globalNetworkId ID of the Global Network of the site to retrieve.
     * @param siteId ID of the specific site to retrieve.
     * @param tags Key-value tags for the Site.
     * @return A collection of values returned by getSite.
     */
    public suspend fun getSite(
        globalNetworkId: String,
        siteId: String,
        tags: Map<String, String>? = null,
    ): GetSiteResult {
        val argument = GetSitePlainArgs(
            globalNetworkId = globalNetworkId,
            siteId = siteId,
            tags = tags,
        )
        return getSiteResultToKotlin(getSitePlain(argument.toJava()).await())
    }

    /**
     * @see [getSite].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;networkmanager&#46;kotlin&#46;inputs&#46;GetSitePlainArgs].
     * @return A collection of values returned by getSite.
     */
    public suspend fun getSite(argument: suspend GetSitePlainArgsBuilder.() -> Unit): GetSiteResult {
        val builder = GetSitePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSiteResultToKotlin(getSitePlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve information about sites.
     * ## Example Usage
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.networkmanager.NetworkmanagerFunctions;
     * import com.pulumi.aws.networkmanager.inputs.GetSitesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = NetworkmanagerFunctions.getSites(GetSitesArgs.builder()
     *             .globalNetworkId(var_.global_network_id())
     *             .tags(Map.of("Env", "test"))
     *             .build());
     *     }
     * }
     * ```
     * @param argument A collection of arguments for invoking getSites.
     * @return A collection of values returned by getSites.
     */
    public suspend fun getSites(argument: GetSitesPlainArgs): GetSitesResult =
        getSitesResultToKotlin(getSitesPlain(argument.toJava()).await())

    /**
     * @see [getSites].
     * @param globalNetworkId ID of the Global Network of the sites to retrieve.
     * @param tags Restricts the list to the sites with these tags.
     * @return A collection of values returned by getSites.
     */
    public suspend fun getSites(globalNetworkId: String, tags: Map<String, String>? = null):
        GetSitesResult {
        val argument = GetSitesPlainArgs(
            globalNetworkId = globalNetworkId,
            tags = tags,
        )
        return getSitesResultToKotlin(getSitesPlain(argument.toJava()).await())
    }

    /**
     * @see [getSites].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;networkmanager&#46;kotlin&#46;inputs&#46;GetSitesPlainArgs].
     * @return A collection of values returned by getSites.
     */
    public suspend fun getSites(argument: suspend GetSitesPlainArgsBuilder.() -> Unit):
        GetSitesResult {
        val builder = GetSitesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSitesResultToKotlin(getSitesPlain(builtArgument.toJava()).await())
    }
}
