@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin

import com.pulumi.aws.networkmanager.kotlin.outputs.SiteLocation
import com.pulumi.aws.networkmanager.kotlin.outputs.SiteLocation.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Site].
 */
@PulumiTagMarker
public class SiteResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SiteArgs = SiteArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SiteArgsBuilder.() -> Unit) {
        val builder = SiteArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Site {
        val builtJavaResource = com.pulumi.aws.networkmanager.Site(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Site(builtJavaResource)
    }
}

/**
 * Creates a site in a global network.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkmanager.GlobalNetwork;
 * import com.pulumi.aws.networkmanager.Site;
 * import com.pulumi.aws.networkmanager.SiteArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleGlobalNetwork = new GlobalNetwork("exampleGlobalNetwork");
 *         var exampleSite = new Site("exampleSite", SiteArgs.builder()
 *             .globalNetworkId(exampleGlobalNetwork.id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_networkmanager_site` using the site ARN. For example:
 * ```sh
 *  $ pulumi import aws:networkmanager/site:Site example arn:aws:networkmanager::123456789012:site/global-network-0d47f6t230mz46dy4/site-444555aaabbb11223
 * ```
 *
 */
public class Site internal constructor(
    override val javaResource: com.pulumi.aws.networkmanager.Site,
) : KotlinCustomResource(javaResource, SiteMapper) {
    /**
     * Site Amazon Resource Name (ARN)
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Description of the Site.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the Global Network to create the site in.
     */
    public val globalNetworkId: Output<String>
        get() = javaResource.globalNetworkId().applyValue({ args0 -> args0 })

    /**
     * The site location as documented below.
     */
    public val location: Output<SiteLocation>?
        get() = javaResource.location().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Key-value tags for the Site. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object SiteMapper : ResourceMapper<Site> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.networkmanager.Site::class == javaResource::class

    override fun map(javaResource: Resource): Site = Site(
        javaResource as
            com.pulumi.aws.networkmanager.Site,
    )
}

/**
 * @see [Site].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Site].
 */
public suspend fun site(name: String, block: suspend SiteResourceBuilder.() -> Unit): Site {
    val builder = SiteResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Site].
 * @param name The _unique_ name of the resulting resource.
 */
public fun site(name: String): Site {
    val builder = SiteResourceBuilder()
    builder.name(name)
    return builder.build()
}
