@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin

import com.pulumi.aws.networkmanager.SiteToSiteVpnAttachmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Network Manager SiteToSiteAttachment.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkmanager.SiteToSiteVpnAttachment;
 * import com.pulumi.aws.networkmanager.SiteToSiteVpnAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new SiteToSiteVpnAttachment("example", SiteToSiteVpnAttachmentArgs.builder()
 *             .coreNetworkId(awscc_networkmanager_core_network.example().id())
 *             .vpnConnectionArn(aws_vpn_connection.example().arn())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_networkmanager_site_to_site_vpn_attachment` using the attachment ID. For example:
 * ```sh
 *  $ pulumi import aws:networkmanager/siteToSiteVpnAttachment:SiteToSiteVpnAttachment example attachment-0f8fa60d2238d1bd8
 * ```
 * @property coreNetworkId The ID of a core network for the VPN attachment.
 * @property tags Key-value tags for the attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property vpnConnectionArn The ARN of the site-to-site VPN connection.
 * The following arguments are optional:
 */
public data class SiteToSiteVpnAttachmentArgs(
    public val coreNetworkId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vpnConnectionArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.networkmanager.SiteToSiteVpnAttachmentArgs> {
    override fun toJava(): com.pulumi.aws.networkmanager.SiteToSiteVpnAttachmentArgs =
        com.pulumi.aws.networkmanager.SiteToSiteVpnAttachmentArgs.builder()
            .coreNetworkId(coreNetworkId?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpnConnectionArn(vpnConnectionArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SiteToSiteVpnAttachmentArgs].
 */
@PulumiTagMarker
public class SiteToSiteVpnAttachmentArgsBuilder internal constructor() {
    private var coreNetworkId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vpnConnectionArn: Output<String>? = null

    /**
     * @param value The ID of a core network for the VPN attachment.
     */
    @JvmName("lfuchfqicvdcmdxs")
    public suspend fun coreNetworkId(`value`: Output<String>) {
        this.coreNetworkId = value
    }

    /**
     * @param value Key-value tags for the attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("jvedhfubmrtxxeys")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The ARN of the site-to-site VPN connection.
     * The following arguments are optional:
     */
    @JvmName("wbgmjnnnmkdvoshm")
    public suspend fun vpnConnectionArn(`value`: Output<String>) {
        this.vpnConnectionArn = value
    }

    /**
     * @param value The ID of a core network for the VPN attachment.
     */
    @JvmName("bgogylaxixhfvwpl")
    public suspend fun coreNetworkId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.coreNetworkId = mapped
    }

    /**
     * @param value Key-value tags for the attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("jvfhrylnmuhwchrg")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value tags for the attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("fepeyvuxexraapxs")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The ARN of the site-to-site VPN connection.
     * The following arguments are optional:
     */
    @JvmName("gxdrlpmjftwgriul")
    public suspend fun vpnConnectionArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpnConnectionArn = mapped
    }

    internal fun build(): SiteToSiteVpnAttachmentArgs = SiteToSiteVpnAttachmentArgs(
        coreNetworkId = coreNetworkId,
        tags = tags,
        vpnConnectionArn = vpnConnectionArn,
    )
}
