@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [TransitGatewayConnectPeerAssociation].
 */
@PulumiTagMarker
public class TransitGatewayConnectPeerAssociationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TransitGatewayConnectPeerAssociationArgs =
        TransitGatewayConnectPeerAssociationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend
    fun args(block: suspend TransitGatewayConnectPeerAssociationArgsBuilder.() -> Unit) {
        val builder = TransitGatewayConnectPeerAssociationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): TransitGatewayConnectPeerAssociation {
        val builtJavaResource =
            com.pulumi.aws.networkmanager.TransitGatewayConnectPeerAssociation(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return TransitGatewayConnectPeerAssociation(builtJavaResource)
    }
}

/**
 * Associates a transit gateway Connect peer with a device, and optionally, with a link.
 * If you specify a link, it must be associated with the specified device.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkmanager.TransitGatewayConnectPeerAssociation;
 * import com.pulumi.aws.networkmanager.TransitGatewayConnectPeerAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new TransitGatewayConnectPeerAssociation("example", TransitGatewayConnectPeerAssociationArgs.builder()
 *             .globalNetworkId(aws_networkmanager_global_network.example().id())
 *             .deviceId(aws_networkmanager_device.example().id())
 *             .transitGatewayConnectPeerArn(aws_ec2_transit_gateway_connect_peer.example().arn())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_networkmanager_transit_gateway_connect_peer_association` using the global network ID and customer gateway ARN. For example:
 * ```sh
 *  $ pulumi import aws:networkmanager/transitGatewayConnectPeerAssociation:TransitGatewayConnectPeerAssociation example global-network-0d47f6t230mz46dy4,arn:aws:ec2:us-west-2:123456789012:transit-gateway-connect-peer/tgw-connect-peer-12345678
 * ```
 *
 */
public class TransitGatewayConnectPeerAssociation internal constructor(
    override val javaResource: com.pulumi.aws.networkmanager.TransitGatewayConnectPeerAssociation,
) : KotlinCustomResource(javaResource, TransitGatewayConnectPeerAssociationMapper) {
    /**
     * The ID of the device.
     */
    public val deviceId: Output<String>
        get() = javaResource.deviceId().applyValue({ args0 -> args0 })

    /**
     * The ID of the global network.
     */
    public val globalNetworkId: Output<String>
        get() = javaResource.globalNetworkId().applyValue({ args0 -> args0 })

    /**
     * The ID of the link.
     */
    public val linkId: Output<String>?
        get() = javaResource.linkId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The Amazon Resource Name (ARN) of the Connect peer.
     */
    public val transitGatewayConnectPeerArn: Output<String>
        get() = javaResource.transitGatewayConnectPeerArn().applyValue({ args0 -> args0 })
}

public object TransitGatewayConnectPeerAssociationMapper :
    ResourceMapper<TransitGatewayConnectPeerAssociation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.networkmanager.TransitGatewayConnectPeerAssociation::class == javaResource::class

    override fun map(javaResource: Resource): TransitGatewayConnectPeerAssociation =
        TransitGatewayConnectPeerAssociation(
            javaResource as
                com.pulumi.aws.networkmanager.TransitGatewayConnectPeerAssociation,
        )
}

/**
 * @see [TransitGatewayConnectPeerAssociation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TransitGatewayConnectPeerAssociation].
 */
public suspend fun transitGatewayConnectPeerAssociation(
    name: String,
    block: suspend TransitGatewayConnectPeerAssociationResourceBuilder.() -> Unit,
):
    TransitGatewayConnectPeerAssociation {
    val builder = TransitGatewayConnectPeerAssociationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TransitGatewayConnectPeerAssociation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun transitGatewayConnectPeerAssociation(name: String):
    TransitGatewayConnectPeerAssociation {
    val builder = TransitGatewayConnectPeerAssociationResourceBuilder()
    builder.name(name)
    return builder.build()
}
