@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin

import com.pulumi.aws.networkmanager.TransitGatewayPeeringArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Creates a peering connection between an AWS Cloud WAN core network and an AWS Transit Gateway.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkmanager.TransitGatewayPeering;
 * import com.pulumi.aws.networkmanager.TransitGatewayPeeringArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new TransitGatewayPeering("example", TransitGatewayPeeringArgs.builder()
 *             .coreNetworkId(awscc_networkmanager_core_network.example().id())
 *             .transitGatewayArn(aws_ec2_transit_gateway.example().arn())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_networkmanager_transit_gateway_peering` using the peering ID. For example:
 * ```sh
 *  $ pulumi import aws:networkmanager/transitGatewayPeering:TransitGatewayPeering example peering-444555aaabbb11223
 * ```
 * @property coreNetworkId The ID of a core network.
 * @property tags Key-value tags for the peering. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property transitGatewayArn The ARN of the transit gateway for the peering request.
 */
public data class TransitGatewayPeeringArgs(
    public val coreNetworkId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val transitGatewayArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.networkmanager.TransitGatewayPeeringArgs> {
    override fun toJava(): com.pulumi.aws.networkmanager.TransitGatewayPeeringArgs =
        com.pulumi.aws.networkmanager.TransitGatewayPeeringArgs.builder()
            .coreNetworkId(coreNetworkId?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .transitGatewayArn(transitGatewayArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TransitGatewayPeeringArgs].
 */
@PulumiTagMarker
public class TransitGatewayPeeringArgsBuilder internal constructor() {
    private var coreNetworkId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var transitGatewayArn: Output<String>? = null

    /**
     * @param value The ID of a core network.
     */
    @JvmName("eaahdepiktbtpsik")
    public suspend fun coreNetworkId(`value`: Output<String>) {
        this.coreNetworkId = value
    }

    /**
     * @param value Key-value tags for the peering. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("naocprdcggvsctjw")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The ARN of the transit gateway for the peering request.
     */
    @JvmName("lujcvopfykiwiogh")
    public suspend fun transitGatewayArn(`value`: Output<String>) {
        this.transitGatewayArn = value
    }

    /**
     * @param value The ID of a core network.
     */
    @JvmName("snbkrggayxadhytk")
    public suspend fun coreNetworkId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.coreNetworkId = mapped
    }

    /**
     * @param value Key-value tags for the peering. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rtbxysfjivydbeqf")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value tags for the peering. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("jpggnogbknsntylo")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The ARN of the transit gateway for the peering request.
     */
    @JvmName("ckegaxhxrojhcdok")
    public suspend fun transitGatewayArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitGatewayArn = mapped
    }

    internal fun build(): TransitGatewayPeeringArgs = TransitGatewayPeeringArgs(
        coreNetworkId = coreNetworkId,
        tags = tags,
        transitGatewayArn = transitGatewayArn,
    )
}
