@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin

import com.pulumi.aws.networkmanager.TransitGatewayRegistrationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Registers a transit gateway to a global network. The transit gateway can be in any AWS Region,
 * but it must be owned by the same AWS account that owns the global network.
 * You cannot register a transit gateway in more than one global network.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkmanager.GlobalNetwork;
 * import com.pulumi.aws.networkmanager.GlobalNetworkArgs;
 * import com.pulumi.aws.ec2transitgateway.TransitGateway;
 * import com.pulumi.aws.networkmanager.TransitGatewayRegistration;
 * import com.pulumi.aws.networkmanager.TransitGatewayRegistrationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleGlobalNetwork = new GlobalNetwork("exampleGlobalNetwork", GlobalNetworkArgs.builder()
 *             .description("example")
 *             .build());
 *         var exampleTransitGateway = new TransitGateway("exampleTransitGateway");
 *         var exampleTransitGatewayRegistration = new TransitGatewayRegistration("exampleTransitGatewayRegistration", TransitGatewayRegistrationArgs.builder()
 *             .globalNetworkId(exampleGlobalNetwork.id())
 *             .transitGatewayArn(exampleTransitGateway.arn())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_networkmanager_transit_gateway_registration` using the global network ID and transit gateway ARN. For example:
 * ```sh
 *  $ pulumi import aws:networkmanager/transitGatewayRegistration:TransitGatewayRegistration example global-network-0d47f6t230mz46dy4,arn:aws:ec2:us-west-2:123456789012:transit-gateway/tgw-123abc05e04123abc
 * ```
 * @property globalNetworkId The ID of the Global Network to register to.
 * @property transitGatewayArn The ARN of the Transit Gateway to register.
 */
public data class TransitGatewayRegistrationArgs(
    public val globalNetworkId: Output<String>? = null,
    public val transitGatewayArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.networkmanager.TransitGatewayRegistrationArgs> {
    override fun toJava(): com.pulumi.aws.networkmanager.TransitGatewayRegistrationArgs =
        com.pulumi.aws.networkmanager.TransitGatewayRegistrationArgs.builder()
            .globalNetworkId(globalNetworkId?.applyValue({ args0 -> args0 }))
            .transitGatewayArn(transitGatewayArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TransitGatewayRegistrationArgs].
 */
@PulumiTagMarker
public class TransitGatewayRegistrationArgsBuilder internal constructor() {
    private var globalNetworkId: Output<String>? = null

    private var transitGatewayArn: Output<String>? = null

    /**
     * @param value The ID of the Global Network to register to.
     */
    @JvmName("meyydbuovadhbwou")
    public suspend fun globalNetworkId(`value`: Output<String>) {
        this.globalNetworkId = value
    }

    /**
     * @param value The ARN of the Transit Gateway to register.
     */
    @JvmName("pkbnsgfkrkncergh")
    public suspend fun transitGatewayArn(`value`: Output<String>) {
        this.transitGatewayArn = value
    }

    /**
     * @param value The ID of the Global Network to register to.
     */
    @JvmName("gyayhmcgocvntjyh")
    public suspend fun globalNetworkId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.globalNetworkId = mapped
    }

    /**
     * @param value The ARN of the Transit Gateway to register.
     */
    @JvmName("ytxyeefmcgfwnyed")
    public suspend fun transitGatewayArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitGatewayArn = mapped
    }

    internal fun build(): TransitGatewayRegistrationArgs = TransitGatewayRegistrationArgs(
        globalNetworkId = globalNetworkId,
        transitGatewayArn = transitGatewayArn,
    )
}
