@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [TransitGatewayRouteTableAttachment].
 */
@PulumiTagMarker
public class TransitGatewayRouteTableAttachmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TransitGatewayRouteTableAttachmentArgs = TransitGatewayRouteTableAttachmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TransitGatewayRouteTableAttachmentArgsBuilder.() -> Unit) {
        val builder = TransitGatewayRouteTableAttachmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): TransitGatewayRouteTableAttachment {
        val builtJavaResource =
            com.pulumi.aws.networkmanager.TransitGatewayRouteTableAttachment(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return TransitGatewayRouteTableAttachment(builtJavaResource)
    }
}

/**
 * Creates a transit gateway route table attachment.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkmanager.TransitGatewayRouteTableAttachment;
 * import com.pulumi.aws.networkmanager.TransitGatewayRouteTableAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new TransitGatewayRouteTableAttachment("example", TransitGatewayRouteTableAttachmentArgs.builder()
 *             .peeringId(aws_networkmanager_transit_gateway_peering.example().id())
 *             .transitGatewayRouteTableArn(aws_ec2_transit_gateway_route_table.example().arn())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_networkmanager_transit_gateway_route_table_attachment` using the attachment ID. For example:
 * ```sh
 *  $ pulumi import aws:networkmanager/transitGatewayRouteTableAttachment:TransitGatewayRouteTableAttachment example attachment-0f8fa60d2238d1bd8
 * ```
 *
 */
public class TransitGatewayRouteTableAttachment internal constructor(
    override val javaResource: com.pulumi.aws.networkmanager.TransitGatewayRouteTableAttachment,
) : KotlinCustomResource(javaResource, TransitGatewayRouteTableAttachmentMapper) {
    /**
     * Attachment Amazon Resource Name (ARN).
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The policy rule number associated with the attachment.
     */
    public val attachmentPolicyRuleNumber: Output<Int>
        get() = javaResource.attachmentPolicyRuleNumber().applyValue({ args0 -> args0 })

    /**
     * The type of attachment.
     */
    public val attachmentType: Output<String>
        get() = javaResource.attachmentType().applyValue({ args0 -> args0 })

    /**
     * The ARN of the core network.
     */
    public val coreNetworkArn: Output<String>
        get() = javaResource.coreNetworkArn().applyValue({ args0 -> args0 })

    /**
     * The ID of the core network.
     */
    public val coreNetworkId: Output<String>
        get() = javaResource.coreNetworkId().applyValue({ args0 -> args0 })

    /**
     * The edge location for the peer.
     */
    public val edgeLocation: Output<String>
        get() = javaResource.edgeLocation().applyValue({ args0 -> args0 })

    /**
     * The ID of the attachment account owner.
     */
    public val ownerAccountId: Output<String>
        get() = javaResource.ownerAccountId().applyValue({ args0 -> args0 })

    /**
     * The ID of the peer for the attachment.
     */
    public val peeringId: Output<String>
        get() = javaResource.peeringId().applyValue({ args0 -> args0 })

    /**
     * The attachment resource ARN.
     */
    public val resourceArn: Output<String>
        get() = javaResource.resourceArn().applyValue({ args0 -> args0 })

    /**
     * The name of the segment attachment.
     */
    public val segmentName: Output<String>
        get() = javaResource.segmentName().applyValue({ args0 -> args0 })

    /**
     * The state of the attachment.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * Key-value tags for the attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The ARN of the transit gateway route table for the attachment.
     */
    public val transitGatewayRouteTableArn: Output<String>
        get() = javaResource.transitGatewayRouteTableArn().applyValue({ args0 -> args0 })
}

public object TransitGatewayRouteTableAttachmentMapper :
    ResourceMapper<TransitGatewayRouteTableAttachment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.networkmanager.TransitGatewayRouteTableAttachment::class == javaResource::class

    override fun map(javaResource: Resource): TransitGatewayRouteTableAttachment =
        TransitGatewayRouteTableAttachment(
            javaResource as
                com.pulumi.aws.networkmanager.TransitGatewayRouteTableAttachment,
        )
}

/**
 * @see [TransitGatewayRouteTableAttachment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TransitGatewayRouteTableAttachment].
 */
public suspend fun transitGatewayRouteTableAttachment(
    name: String,
    block: suspend TransitGatewayRouteTableAttachmentResourceBuilder.() -> Unit,
):
    TransitGatewayRouteTableAttachment {
    val builder = TransitGatewayRouteTableAttachmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TransitGatewayRouteTableAttachment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun transitGatewayRouteTableAttachment(name: String): TransitGatewayRouteTableAttachment {
    val builder = TransitGatewayRouteTableAttachmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
