@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin

import com.pulumi.aws.networkmanager.TransitGatewayRouteTableAttachmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Creates a transit gateway route table attachment.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkmanager.TransitGatewayRouteTableAttachment;
 * import com.pulumi.aws.networkmanager.TransitGatewayRouteTableAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new TransitGatewayRouteTableAttachment("example", TransitGatewayRouteTableAttachmentArgs.builder()
 *             .peeringId(aws_networkmanager_transit_gateway_peering.example().id())
 *             .transitGatewayRouteTableArn(aws_ec2_transit_gateway_route_table.example().arn())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_networkmanager_transit_gateway_route_table_attachment` using the attachment ID. For example:
 * ```sh
 *  $ pulumi import aws:networkmanager/transitGatewayRouteTableAttachment:TransitGatewayRouteTableAttachment example attachment-0f8fa60d2238d1bd8
 * ```
 * @property peeringId The ID of the peer for the attachment.
 * @property tags Key-value tags for the attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property transitGatewayRouteTableArn The ARN of the transit gateway route table for the attachment.
 */
public data class TransitGatewayRouteTableAttachmentArgs(
    public val peeringId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val transitGatewayRouteTableArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.networkmanager.TransitGatewayRouteTableAttachmentArgs> {
    override fun toJava(): com.pulumi.aws.networkmanager.TransitGatewayRouteTableAttachmentArgs =
        com.pulumi.aws.networkmanager.TransitGatewayRouteTableAttachmentArgs.builder()
            .peeringId(peeringId?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .transitGatewayRouteTableArn(transitGatewayRouteTableArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TransitGatewayRouteTableAttachmentArgs].
 */
@PulumiTagMarker
public class TransitGatewayRouteTableAttachmentArgsBuilder internal constructor() {
    private var peeringId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var transitGatewayRouteTableArn: Output<String>? = null

    /**
     * @param value The ID of the peer for the attachment.
     */
    @JvmName("euhakioggkaajqvo")
    public suspend fun peeringId(`value`: Output<String>) {
        this.peeringId = value
    }

    /**
     * @param value Key-value tags for the attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ukiyhvgkcaqcqmvj")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The ARN of the transit gateway route table for the attachment.
     */
    @JvmName("xaioupissyuwgelt")
    public suspend fun transitGatewayRouteTableArn(`value`: Output<String>) {
        this.transitGatewayRouteTableArn = value
    }

    /**
     * @param value The ID of the peer for the attachment.
     */
    @JvmName("egiaexhrsokfavut")
    public suspend fun peeringId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peeringId = mapped
    }

    /**
     * @param value Key-value tags for the attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("nqvjarcnfftsarow")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value tags for the attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ikklmyfkgeteqmyo")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The ARN of the transit gateway route table for the attachment.
     */
    @JvmName("goqxqvtphpicxwqe")
    public suspend fun transitGatewayRouteTableArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitGatewayRouteTableArn = mapped
    }

    internal fun build(): TransitGatewayRouteTableAttachmentArgs =
        TransitGatewayRouteTableAttachmentArgs(
            peeringId = peeringId,
            tags = tags,
            transitGatewayRouteTableArn = transitGatewayRouteTableArn,
        )
}
