@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin

import com.pulumi.aws.networkmanager.VpcAttachmentArgs.builder
import com.pulumi.aws.networkmanager.kotlin.inputs.VpcAttachmentOptionsArgs
import com.pulumi.aws.networkmanager.kotlin.inputs.VpcAttachmentOptionsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Network Manager VPC Attachment.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.networkmanager.VpcAttachment;
 * import com.pulumi.aws.networkmanager.VpcAttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new VpcAttachment("example", VpcAttachmentArgs.builder()
 *             .subnetArns(aws_subnet.example().arn())
 *             .coreNetworkId(awscc_networkmanager_core_network.example().id())
 *             .vpcArn(aws_vpc.example().arn())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_networkmanager_vpc_attachment` using the attachment ID. For example:
 * ```sh
 *  $ pulumi import aws:networkmanager/vpcAttachment:VpcAttachment example attachment-0f8fa60d2238d1bd8
 * ```
 * @property coreNetworkId The ID of a core network for the VPC attachment.
 * @property options Options for the VPC attachment.
 * @property subnetArns The subnet ARN of the VPC attachment.
 * @property tags Key-value tags for the attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property vpcArn The ARN of the VPC.
 * The following arguments are optional:
 */
public data class VpcAttachmentArgs(
    public val coreNetworkId: Output<String>? = null,
    public val options: Output<VpcAttachmentOptionsArgs>? = null,
    public val subnetArns: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vpcArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.networkmanager.VpcAttachmentArgs> {
    override fun toJava(): com.pulumi.aws.networkmanager.VpcAttachmentArgs =
        com.pulumi.aws.networkmanager.VpcAttachmentArgs.builder()
            .coreNetworkId(coreNetworkId?.applyValue({ args0 -> args0 }))
            .options(options?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .subnetArns(subnetArns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcArn(vpcArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VpcAttachmentArgs].
 */
@PulumiTagMarker
public class VpcAttachmentArgsBuilder internal constructor() {
    private var coreNetworkId: Output<String>? = null

    private var options: Output<VpcAttachmentOptionsArgs>? = null

    private var subnetArns: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vpcArn: Output<String>? = null

    /**
     * @param value The ID of a core network for the VPC attachment.
     */
    @JvmName("osmhamxmlaasuqbf")
    public suspend fun coreNetworkId(`value`: Output<String>) {
        this.coreNetworkId = value
    }

    /**
     * @param value Options for the VPC attachment.
     */
    @JvmName("snlhlsxvcxynglfc")
    public suspend fun options(`value`: Output<VpcAttachmentOptionsArgs>) {
        this.options = value
    }

    /**
     * @param value The subnet ARN of the VPC attachment.
     */
    @JvmName("fbijelhmtnsncavc")
    public suspend fun subnetArns(`value`: Output<List<String>>) {
        this.subnetArns = value
    }

    @JvmName("tppuljmokwmfbuiv")
    public suspend fun subnetArns(vararg values: Output<String>) {
        this.subnetArns = Output.all(values.asList())
    }

    /**
     * @param values The subnet ARN of the VPC attachment.
     */
    @JvmName("jkhsilvsjkvtjggk")
    public suspend fun subnetArns(values: List<Output<String>>) {
        this.subnetArns = Output.all(values)
    }

    /**
     * @param value Key-value tags for the attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("dcuhsrauqsctietm")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The ARN of the VPC.
     * The following arguments are optional:
     */
    @JvmName("ubwttepyvxlhojtj")
    public suspend fun vpcArn(`value`: Output<String>) {
        this.vpcArn = value
    }

    /**
     * @param value The ID of a core network for the VPC attachment.
     */
    @JvmName("jwcwoiqypscctxls")
    public suspend fun coreNetworkId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.coreNetworkId = mapped
    }

    /**
     * @param value Options for the VPC attachment.
     */
    @JvmName("eklqriarplckwnba")
    public suspend fun options(`value`: VpcAttachmentOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.options = mapped
    }

    /**
     * @param argument Options for the VPC attachment.
     */
    @JvmName("nxxcnmpfxjfmihiu")
    public suspend fun options(argument: suspend VpcAttachmentOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = VpcAttachmentOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.options = mapped
    }

    /**
     * @param value The subnet ARN of the VPC attachment.
     */
    @JvmName("pkbqhhtdrrlhughq")
    public suspend fun subnetArns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetArns = mapped
    }

    /**
     * @param values The subnet ARN of the VPC attachment.
     */
    @JvmName("ccphkkdbyhsrtyjg")
    public suspend fun subnetArns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetArns = mapped
    }

    /**
     * @param value Key-value tags for the attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ibprscoqceeqwdch")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value tags for the attachment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("nbwfdeafhocofxqn")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The ARN of the VPC.
     * The following arguments are optional:
     */
    @JvmName("wiynoksclxppivxc")
    public suspend fun vpcArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcArn = mapped
    }

    internal fun build(): VpcAttachmentArgs = VpcAttachmentArgs(
        coreNetworkId = coreNetworkId,
        options = options,
        subnetArns = subnetArns,
        tags = tags,
        vpcArn = vpcArn,
    )
}
