@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin.inputs

import com.pulumi.aws.networkmanager.inputs.ConnectPeerBgpOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property peerAsn
 */
public data class ConnectPeerBgpOptionsArgs(
    public val peerAsn: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.networkmanager.inputs.ConnectPeerBgpOptionsArgs> {
    override fun toJava(): com.pulumi.aws.networkmanager.inputs.ConnectPeerBgpOptionsArgs =
        com.pulumi.aws.networkmanager.inputs.ConnectPeerBgpOptionsArgs.builder()
            .peerAsn(peerAsn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectPeerBgpOptionsArgs].
 */
@PulumiTagMarker
public class ConnectPeerBgpOptionsArgsBuilder internal constructor() {
    private var peerAsn: Output<Int>? = null

    /**
     * @param value
     */
    @JvmName("rneqvcqrxcxinbpf")
    public suspend fun peerAsn(`value`: Output<Int>) {
        this.peerAsn = value
    }

    /**
     * @param value
     */
    @JvmName("cbyparbsrshlsvue")
    public suspend fun peerAsn(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peerAsn = mapped
    }

    internal fun build(): ConnectPeerBgpOptionsArgs = ConnectPeerBgpOptionsArgs(
        peerAsn = peerAsn,
    )
}
