@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin.inputs

import com.pulumi.aws.networkmanager.inputs.GetDevicesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getDevices.
 * @property globalNetworkId ID of the Global Network of the devices to retrieve.
 * @property siteId ID of the site of the devices to retrieve.
 * @property tags Restricts the list to the devices with these tags.
 */
public data class GetDevicesPlainArgs(
    public val globalNetworkId: String,
    public val siteId: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.networkmanager.inputs.GetDevicesPlainArgs> {
    override fun toJava(): com.pulumi.aws.networkmanager.inputs.GetDevicesPlainArgs =
        com.pulumi.aws.networkmanager.inputs.GetDevicesPlainArgs.builder()
            .globalNetworkId(globalNetworkId.let({ args0 -> args0 }))
            .siteId(siteId?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetDevicesPlainArgs].
 */
@PulumiTagMarker
public class GetDevicesPlainArgsBuilder internal constructor() {
    private var globalNetworkId: String? = null

    private var siteId: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value ID of the Global Network of the devices to retrieve.
     */
    @JvmName("ieolsrhsychqhxih")
    public suspend fun globalNetworkId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.globalNetworkId = mapped
    }

    /**
     * @param value ID of the site of the devices to retrieve.
     */
    @JvmName("yybdhxhywypsqfir")
    public suspend fun siteId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.siteId = mapped
    }

    /**
     * @param value Restricts the list to the devices with these tags.
     */
    @JvmName("mxlounyqmtgaytus")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Restricts the list to the devices with these tags.
     */
    @JvmName("alcaacvdonnydece")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetDevicesPlainArgs = GetDevicesPlainArgs(
        globalNetworkId = globalNetworkId ?: throw PulumiNullFieldException("globalNetworkId"),
        siteId = siteId,
        tags = tags,
    )
}
