@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin.inputs

import com.pulumi.aws.networkmanager.inputs.GetGlobalNetworkPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getGlobalNetwork.
 * @property globalNetworkId ID of the specific global network to retrieve.
 * @property tags Map of resource tags.
 */
public data class GetGlobalNetworkPlainArgs(
    public val globalNetworkId: String,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.networkmanager.inputs.GetGlobalNetworkPlainArgs> {
    override fun toJava(): com.pulumi.aws.networkmanager.inputs.GetGlobalNetworkPlainArgs =
        com.pulumi.aws.networkmanager.inputs.GetGlobalNetworkPlainArgs.builder()
            .globalNetworkId(globalNetworkId.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetGlobalNetworkPlainArgs].
 */
@PulumiTagMarker
public class GetGlobalNetworkPlainArgsBuilder internal constructor() {
    private var globalNetworkId: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value ID of the specific global network to retrieve.
     */
    @JvmName("trlhwlysocgpqgsm")
    public suspend fun globalNetworkId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.globalNetworkId = mapped
    }

    /**
     * @param value Map of resource tags.
     */
    @JvmName("chlfxsffdkxqghwv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of resource tags.
     */
    @JvmName("pcoitwvdjbindoup")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetGlobalNetworkPlainArgs = GetGlobalNetworkPlainArgs(
        globalNetworkId = globalNetworkId ?: throw PulumiNullFieldException("globalNetworkId"),
        tags = tags,
    )
}
