@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin.inputs

import com.pulumi.aws.networkmanager.inputs.GetLinkPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getLink.
 * @property globalNetworkId ID of the Global Network of the link to retrieve.
 * @property linkId ID of the specific link to retrieve.
 * @property tags Key-value tags for the link.
 */
public data class GetLinkPlainArgs(
    public val globalNetworkId: String,
    public val linkId: String,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.networkmanager.inputs.GetLinkPlainArgs> {
    override fun toJava(): com.pulumi.aws.networkmanager.inputs.GetLinkPlainArgs =
        com.pulumi.aws.networkmanager.inputs.GetLinkPlainArgs.builder()
            .globalNetworkId(globalNetworkId.let({ args0 -> args0 }))
            .linkId(linkId.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetLinkPlainArgs].
 */
@PulumiTagMarker
public class GetLinkPlainArgsBuilder internal constructor() {
    private var globalNetworkId: String? = null

    private var linkId: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value ID of the Global Network of the link to retrieve.
     */
    @JvmName("oedwrieksfptnnsl")
    public suspend fun globalNetworkId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.globalNetworkId = mapped
    }

    /**
     * @param value ID of the specific link to retrieve.
     */
    @JvmName("clbpgdpkdkqpsrmq")
    public suspend fun linkId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.linkId = mapped
    }

    /**
     * @param value Key-value tags for the link.
     */
    @JvmName("tapfucidbrdjumuo")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Key-value tags for the link.
     */
    @JvmName("gdxxqgliccpjelgh")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetLinkPlainArgs = GetLinkPlainArgs(
        globalNetworkId = globalNetworkId ?: throw PulumiNullFieldException("globalNetworkId"),
        linkId = linkId ?: throw PulumiNullFieldException("linkId"),
        tags = tags,
    )
}
