@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin.inputs

import com.pulumi.aws.networkmanager.inputs.SiteLocationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property address Address of the location.
 * @property latitude Latitude of the location.
 * @property longitude Longitude of the location.
 */
public data class SiteLocationArgs(
    public val address: Output<String>? = null,
    public val latitude: Output<String>? = null,
    public val longitude: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.networkmanager.inputs.SiteLocationArgs> {
    override fun toJava(): com.pulumi.aws.networkmanager.inputs.SiteLocationArgs =
        com.pulumi.aws.networkmanager.inputs.SiteLocationArgs.builder()
            .address(address?.applyValue({ args0 -> args0 }))
            .latitude(latitude?.applyValue({ args0 -> args0 }))
            .longitude(longitude?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SiteLocationArgs].
 */
@PulumiTagMarker
public class SiteLocationArgsBuilder internal constructor() {
    private var address: Output<String>? = null

    private var latitude: Output<String>? = null

    private var longitude: Output<String>? = null

    /**
     * @param value Address of the location.
     */
    @JvmName("dfrnwlamdilaiolk")
    public suspend fun address(`value`: Output<String>) {
        this.address = value
    }

    /**
     * @param value Latitude of the location.
     */
    @JvmName("hgdfnnigvhdbtkvo")
    public suspend fun latitude(`value`: Output<String>) {
        this.latitude = value
    }

    /**
     * @param value Longitude of the location.
     */
    @JvmName("jtvehyasdoimlvey")
    public suspend fun longitude(`value`: Output<String>) {
        this.longitude = value
    }

    /**
     * @param value Address of the location.
     */
    @JvmName("nfpgwysxploeymjc")
    public suspend fun address(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.address = mapped
    }

    /**
     * @param value Latitude of the location.
     */
    @JvmName("wwvvthsbkmeichpo")
    public suspend fun latitude(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.latitude = mapped
    }

    /**
     * @param value Longitude of the location.
     */
    @JvmName("ednswsngigcqcayx")
    public suspend fun longitude(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.longitude = mapped
    }

    internal fun build(): SiteLocationArgs = SiteLocationArgs(
        address = address,
        latitude = latitude,
        longitude = longitude,
    )
}
