@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin.inputs

import com.pulumi.aws.networkmanager.inputs.VpcAttachmentOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property applianceModeSupport Indicates whether appliance mode is supported.
 * If enabled, traffic flow between a source and destination use the same Availability Zone for the VPC attachment for the lifetime of that flow.
 * If the VPC attachment is pending acceptance, changing this value will recreate the resource.
 * @property ipv6Support Indicates whether IPv6 is supported.
 * If the VPC attachment is pending acceptance, changing this value will recreate the resource.
 */
public data class VpcAttachmentOptionsArgs(
    public val applianceModeSupport: Output<Boolean>? = null,
    public val ipv6Support: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.networkmanager.inputs.VpcAttachmentOptionsArgs> {
    override fun toJava(): com.pulumi.aws.networkmanager.inputs.VpcAttachmentOptionsArgs =
        com.pulumi.aws.networkmanager.inputs.VpcAttachmentOptionsArgs.builder()
            .applianceModeSupport(applianceModeSupport?.applyValue({ args0 -> args0 }))
            .ipv6Support(ipv6Support?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VpcAttachmentOptionsArgs].
 */
@PulumiTagMarker
public class VpcAttachmentOptionsArgsBuilder internal constructor() {
    private var applianceModeSupport: Output<Boolean>? = null

    private var ipv6Support: Output<Boolean>? = null

    /**
     * @param value Indicates whether appliance mode is supported.
     * If enabled, traffic flow between a source and destination use the same Availability Zone for the VPC attachment for the lifetime of that flow.
     * If the VPC attachment is pending acceptance, changing this value will recreate the resource.
     */
    @JvmName("vrtyxmxfhdcovlxh")
    public suspend fun applianceModeSupport(`value`: Output<Boolean>) {
        this.applianceModeSupport = value
    }

    /**
     * @param value Indicates whether IPv6 is supported.
     * If the VPC attachment is pending acceptance, changing this value will recreate the resource.
     */
    @JvmName("oiwufbtswkooreal")
    public suspend fun ipv6Support(`value`: Output<Boolean>) {
        this.ipv6Support = value
    }

    /**
     * @param value Indicates whether appliance mode is supported.
     * If enabled, traffic flow between a source and destination use the same Availability Zone for the VPC attachment for the lifetime of that flow.
     * If the VPC attachment is pending acceptance, changing this value will recreate the resource.
     */
    @JvmName("qpaosqkulktmwaqu")
    public suspend fun applianceModeSupport(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applianceModeSupport = mapped
    }

    /**
     * @param value Indicates whether IPv6 is supported.
     * If the VPC attachment is pending acceptance, changing this value will recreate the resource.
     */
    @JvmName("vktshetdjcuqrpix")
    public suspend fun ipv6Support(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6Support = mapped
    }

    internal fun build(): VpcAttachmentOptionsArgs = VpcAttachmentOptionsArgs(
        applianceModeSupport = applianceModeSupport,
        ipv6Support = ipv6Support,
    )
}
