@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property bgpConfigurations
 * @property coreNetworkAddress A Connect peer core network address.
 * @property insideCidrBlocks The inside IP addresses used for BGP peering. Required when the Connect attachment protocol is `GRE`. See `aws.networkmanager.ConnectAttachment` for details.
 * @property peerAddress The Connect peer address.
 * The following arguments are optional:
 * @property protocol
 */
public data class ConnectPeerConfiguration(
    public val bgpConfigurations: List<ConnectPeerConfigurationBgpConfiguration>? = null,
    public val coreNetworkAddress: String? = null,
    public val insideCidrBlocks: List<String>? = null,
    public val peerAddress: String? = null,
    public val protocol: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.networkmanager.outputs.ConnectPeerConfiguration):
            ConnectPeerConfiguration = ConnectPeerConfiguration(
            bgpConfigurations = javaType.bgpConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.networkmanager.kotlin.outputs.ConnectPeerConfigurationBgpConfiguration.Companion.toKotlin(args0)
                })
            }),
            coreNetworkAddress = javaType.coreNetworkAddress().map({ args0 -> args0 }).orElse(null),
            insideCidrBlocks = javaType.insideCidrBlocks().map({ args0 -> args0 }),
            peerAddress = javaType.peerAddress().map({ args0 -> args0 }).orElse(null),
            protocol = javaType.protocol().map({ args0 -> args0 }).orElse(null),
        )
    }
}
