@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property coreNetworkAddress A Connect peer core network address.
 * @property coreNetworkAsn
 * @property peerAddress The Connect peer address.
 * The following arguments are optional:
 * @property peerAsn
 */
public data class ConnectPeerConfigurationBgpConfiguration(
    public val coreNetworkAddress: String? = null,
    public val coreNetworkAsn: Int? = null,
    public val peerAddress: String? = null,
    public val peerAsn: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.networkmanager.outputs.ConnectPeerConfigurationBgpConfiguration):
            ConnectPeerConfigurationBgpConfiguration = ConnectPeerConfigurationBgpConfiguration(
            coreNetworkAddress = javaType.coreNetworkAddress().map({ args0 -> args0 }).orElse(null),
            coreNetworkAsn = javaType.coreNetworkAsn().map({ args0 -> args0 }).orElse(null),
            peerAddress = javaType.peerAddress().map({ args0 -> args0 }).orElse(null),
            peerAsn = javaType.peerAsn().map({ args0 -> args0 }).orElse(null),
        )
    }
}
