@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.networkmanager.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property edgeLocations Regions where the edges are located.
 * @property name Name of a core network segment.
 * @property sharedSegments Shared segments of a core network.
 */
public data class CoreNetworkSegment(
    public val edgeLocations: List<String>? = null,
    public val name: String? = null,
    public val sharedSegments: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.networkmanager.outputs.CoreNetworkSegment):
            CoreNetworkSegment = CoreNetworkSegment(
            edgeLocations = javaType.edgeLocations().map({ args0 -> args0 }),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            sharedSegments = javaType.sharedSegments().map({ args0 -> args0 }),
        )
    }
}
